/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.model.VenomBallModel;
import baguchan.frostrealm.client.render.state.ProjectileRenderState;
import baguchan.frostrealm.entity.projectile.VenomBall;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;

public class VenomBallRenderer<T extends VenomBall>
extends EntityRenderer<T, ProjectileRenderState> {
    private static final ResourceLocation LLAMA_SPIT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/venom_ball.png");
    private final VenomBallModel<ProjectileRenderState> model;

    public VenomBallRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new VenomBallModel(context.bakeLayer(FrostModelLayers.VENOM_BALL));
    }

    public void submit(ProjectileRenderState llamaSpit, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.25f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(llamaSpit.yRot - 180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(llamaSpit.xRot));
        poseStack.translate(0.0f, -1.3135f, -0.15625f);
        this.model.setupAnim((Object)llamaSpit);
        submitNodeCollector.submitModel(this.model, (Object)llamaSpit, poseStack, this.model.renderType(LLAMA_SPIT_LOCATION), llamaSpit.lightCoords, OverlayTexture.NO_OVERLAY, llamaSpit.outlineColor, null);
        poseStack.popPose();
        super.submit((EntityRenderState)llamaSpit, poseStack, submitNodeCollector, cameraRenderState);
    }

    public ProjectileRenderState createRenderState() {
        return new ProjectileRenderState();
    }

    public void extractRenderState(T p_362104_, ProjectileRenderState p_361028_, float p_362204_) {
        super.extractRenderState(p_362104_, (EntityRenderState)p_361028_, p_362204_);
        p_361028_.xRot = p_362104_.getXRot(p_362204_);
        p_361028_.yRot = p_362104_.getYRot(p_362204_);
    }

    public ResourceLocation getTextureLocation(ProjectileRenderState llamaSpit) {
        return LLAMA_SPIT_LOCATION;
    }
}

