/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.registry.FrostItems;
import java.util.Locale;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public abstract class CraftingDataHelper
extends RecipeProvider {
    public CraftingDataHelper(HolderLookup.Provider generator, RecipeOutput p_323846_) {
        super(generator, p_323846_);
    }

    protected final void foodCooking(Item material, Item result, float xp, RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)200).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smelting_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)100).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smoking_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)600).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("campfire_cooking_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    protected final void foodCooking(Item material, Item result, float xp, RecipeOutput consumer, String recipeName) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)200).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smelting_" + recipeName));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)100).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smoking_" + recipeName));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)xp, (int)600).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("campfire_cooking_" + recipeName));
    }

    protected final void smeltOre(Item material, Item result, float xp, RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)200).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smelting_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)100).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("blasting_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    protected final void smeltOre(Item material, Item result, float xp, RecipeOutput consumer, String recipeName) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)200).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("smelting_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)100).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, CraftingDataHelper.prefix("blasting_" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    protected final void helmetItem(RecipeOutput consumer, String name, Item result, Item material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern("###").pattern("# #").define(Character.valueOf('#'), (ItemLike)material).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void chestplateItem(RecipeOutput consumer, String name, Item result, Item material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)material).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void leggingsItem(RecipeOutput consumer, String name, Item result, Item material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)material).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void bootsItem(RecipeOutput consumer, String name, Item result, Item material) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)material).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void pickaxeItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void swordItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)result).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void axeItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern("##").pattern("#X").pattern(" X").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void shovelItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern("#").pattern("X").pattern("X").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void hoeItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern("##").pattern("X ").pattern("X ").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void sickleItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern("###").pattern("X  ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    protected final void javelinItem(RecipeOutput consumer, String name, Item result, Item material, TagKey<Item> handle) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).pattern(" # ").pattern("#X#").pattern(" X ").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('X'), handle).unlockedBy("has_item", this.has((ItemLike)material)).save(consumer, this.locEquip(name));
    }

    public void makeStairs(RecipeOutput consumer, Block stairsOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairsOut, (int)4).pattern("M  ").pattern("MM ").pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeWall(RecipeOutput consumer, Block wallOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallOut, (int)6).pattern("MMM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeSlab(RecipeOutput consumer, Block slabOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabOut, (int)6).pattern("MMM").define(Character.valueOf('M'), (ItemLike)blockIn).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeWoodFence(RecipeOutput consumer, Block fenceOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceOut, (int)3).pattern("MSM").pattern("MSM").define(Character.valueOf('M'), (ItemLike)blockIn).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeFenceGate(RecipeOutput consumer, Block fenceOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)fenceOut).pattern("SMS").pattern("SMS").define(Character.valueOf('M'), (ItemLike)blockIn).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeDoor(RecipeOutput consumer, Block doorOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)doorOut, (int)3).pattern("DD").pattern("DD").pattern("DD").define(Character.valueOf('D'), (ItemLike)blockIn).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeTrapDoor(RecipeOutput consumer, Block doorOut, Block blockIn) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)doorOut, (int)3).pattern("DDD").pattern("DDD").define(Character.valueOf('D'), (ItemLike)blockIn).unlockedBy("has_" + BuiltInRegistries.BLOCK.getKey((Object)blockIn).getPath(), this.has((ItemLike)blockIn)).save(consumer);
    }

    public void makeFrostTorch(RecipeOutput consumer, Item torchOut) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)torchOut, (int)4).pattern("C").pattern("M").define(Character.valueOf('C'), (ItemLike)FrostItems.FROST_CRYSTAL.get()).define(Character.valueOf('M'), Tags.Items.RODS_WOODEN).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)((Item)FrostItems.FROST_CRYSTAL.get())).getPath(), this.has((ItemLike)FrostItems.FROST_CRYSTAL.get())).save(consumer);
    }

    public static ResourceKey<Recipe<?>> prefix(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name.toLowerCase(Locale.ROOT)));
    }

    protected final ResourceKey<Recipe<?>> locEquip(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)FrostRealm.prefix("equipment/" + name));
    }
}

