/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.provider;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.data.generator.FrostModelTemplates;
import baguchan.frostrealm.data.generator.FrostTextureMappings;
import baguchan.frostrealm.registry.FrostBlocks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.color.item.GrassColorSource;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FrBlockstateModelProvider
extends BlockModelGenerators {
    public static final ModelTemplate GLOW_CUBE = FrostModelTemplates.GLOW_CUBE.extend().renderType("cutout").build();
    public static final ModelTemplate TRANSLUCENT_CUBE = ModelTemplates.CUBE_ALL.extend().renderType("translucent").build();
    public static final ModelTemplate CUTOUT_CUBE = ModelTemplates.CUBE_ALL.extend().renderType("cutout").build();
    public static final ModelTemplate CROP = ModelTemplates.CROP.extend().renderType("cutout").build();
    public static final TexturedModel.Provider LEAVES_PROVIDER = TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)ModelTemplates.LEAVES.extend().renderType("cutout").build());
    public static final TexturedModel.Provider COLUMN_CUTOUT = TexturedModel.createDefault(TextureMapping::column, (ModelTemplate)ModelTemplates.CUBE_COLUMN.extend().renderType("cutout").build());

    public FrBlockstateModelProvider(Consumer<BlockModelDefinitionGenerator> blockStateOutput, ItemModelOutput itemModelOutput, BiConsumer<ResourceLocation, ModelInstance> modelOutput) {
        super(blockStateOutput, itemModelOutput, modelOutput);
    }

    public void createItemWithDoubleGrassTint(Block p_388714_) {
        this.registerSimpleTintedItemModel(p_388714_, ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Block)p_388714_), TextureMapping.layer0((ResourceLocation)TextureMapping.getBlockTexture((Block)p_388714_).withSuffix("_top")), this.modelOutput), (ItemTintSource)new GrassColorSource());
    }

    public void createTintedDoublePlant(Block p_388276_) {
        ResourceLocation resourcelocation = this.createFlatItemModelWithBlockTexture(p_388276_.asItem(), p_388276_, "_top");
        this.registerSimpleTintedItemModel(p_388276_, resourcelocation, (ItemTintSource)new GrassColorSource());
        this.createDoublePlant(p_388276_, BlockModelGenerators.PlantType.TINTED);
    }

    public void createDoublePlant(Block p_388543_, BlockModelGenerators.PlantType p_388551_) {
        MultiVariant resourcelocation = FrBlockstateModelProvider.plainVariant((ResourceLocation)this.createSuffixedVariant(p_388543_, "_top", (ModelTemplate)p_388551_.getCross().extend().renderType("cutout").build(), TextureMapping::cross));
        MultiVariant resourcelocation1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)this.createSuffixedVariant(p_388543_, "_bottom", (ModelTemplate)p_388551_.getCross().extend().renderType("cutout").build(), TextureMapping::cross));
        this.createDoubleBlock(p_388543_, resourcelocation, resourcelocation1);
    }

    public void createCrossBlock(Block block, BlockModelGenerators.PlantType type, TextureMapping mapping) {
        ResourceLocation resourcelocation = type.getCross().extend().renderType(ResourceLocation.withDefaultNamespace((String)"cutout")).build().create(block, mapping, this.modelOutput);
        this.blockStateOutput.accept(FrBlockstateModelProvider.createSimpleBlock(block, resourcelocation));
    }

    public void createPlant(Block plant, Block pot, BlockModelGenerators.PlantType type) {
        this.createCrossBlock(plant, type);
        TextureMapping texturemapping = type.getPlantTextureMapping(plant);
        ResourceLocation resourcelocation = type.getCrossPot().extend().renderType(ResourceLocation.withDefaultNamespace((String)"cutout")).build().create(pot, texturemapping, this.modelOutput);
        this.blockStateOutput.accept(FrBlockstateModelProvider.createSimpleBlock(pot, resourcelocation));
    }

    public void createTrapdoor(Block p_387551_) {
        TextureMapping texturemapping = TextureMapping.defaultTexture((Block)p_387551_);
        MultiVariant multivariant = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.TRAPDOOR_TOP.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput));
        ResourceLocation resourcelocation = ModelTemplates.TRAPDOOR_BOTTOM.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput);
        MultiVariant multivariant1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.TRAPDOOR_OPEN.extend().renderType("cutout").build().create(p_387551_, texturemapping, this.modelOutput));
        this.blockStateOutput.accept(FrBlockstateModelProvider.createTrapdoor((Block)p_387551_, (MultiVariant)multivariant, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)resourcelocation), (MultiVariant)multivariant1));
        this.registerSimpleItemModel(p_387551_, resourcelocation);
    }

    public void createOrientableTrapdoor(Block p_388937_) {
        TextureMapping texturemapping = TextureMapping.defaultTexture((Block)p_388937_);
        MultiVariant multivariant = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.ORIENTABLE_TRAPDOOR_TOP.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput));
        ResourceLocation resourcelocation = ModelTemplates.ORIENTABLE_TRAPDOOR_BOTTOM.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput);
        MultiVariant multivariant1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.ORIENTABLE_TRAPDOOR_OPEN.extend().renderType("cutout").build().create(p_388937_, texturemapping, this.modelOutput));
        this.blockStateOutput.accept(FrBlockstateModelProvider.createOrientableTrapdoor((Block)p_388937_, (MultiVariant)multivariant, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)resourcelocation), (MultiVariant)multivariant1));
        this.registerSimpleItemModel(p_388937_, resourcelocation);
    }

    public void createDoor(Block p_386982_) {
        TextureMapping texturemapping = TextureMapping.door((Block)p_386982_);
        MultiVariant multivariant = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_BOTTOM_LEFT.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_BOTTOM_LEFT_OPEN.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant2 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_BOTTOM_RIGHT.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant3 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_BOTTOM_RIGHT_OPEN.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant4 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_TOP_LEFT.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant5 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_TOP_LEFT_OPEN.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant6 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_TOP_RIGHT.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        MultiVariant multivariant7 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.DOOR_TOP_RIGHT_OPEN.extend().renderType("cutout").build().create(p_386982_, texturemapping, this.modelOutput));
        this.registerSimpleFlatItemModel(p_386982_.asItem());
        this.blockStateOutput.accept(FrBlockstateModelProvider.createDoor((Block)p_386982_, (MultiVariant)multivariant, (MultiVariant)multivariant1, (MultiVariant)multivariant2, (MultiVariant)multivariant3, (MultiVariant)multivariant4, (MultiVariant)multivariant5, (MultiVariant)multivariant6, (MultiVariant)multivariant7));
    }

    public void createCutoutMippedCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.CUBE_ALL.extend().renderType("cutout_mipped").build().create(block, TextureMapping.cube((Block)block), this.modelOutput))));
    }

    public void createTranslucentCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.CUBE_ALL.extend().renderType("translucent").build().create(block, TextureMapping.cube((Block)block), this.modelOutput))));
    }

    public ResourceLocation createTranslucentItemModelWithBlockTexture(Item item, Block block) {
        return ModelTemplates.FLAT_ITEM.extend().renderType("translucent").build().create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Block)block), this.modelOutput);
    }

    public void createCubeColumn(Block side, Block top) {
        TextureMapping mapping = TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)side), (ResourceLocation)TextureMapping.getBlockTexture((Block)top));
        MultiVariant location = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.CUBE_COLUMN.create(side, mapping, this.modelOutput));
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)side, (MultiVariant)location));
    }

    public void createCampfires(Block ... p_387949_) {
        MultiVariant multivariant = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelLocationUtils.decorateBlockModelLocation((String)"campfire_off"));
        for (Block block : p_387949_) {
            MultiVariant multivariant1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.CAMPFIRE.extend().renderType("cutout").build().create(block, TextureMapping.campfire((Block)block), this.modelOutput));
            this.registerSimpleFlatItemModel(block.asItem());
            this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(FrBlockstateModelProvider.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)multivariant1, (MultiVariant)multivariant)).with(ROTATION_HORIZONTAL_FACING_ALT));
        }
    }

    public void createCutoutCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)CUTOUT_CUBE.create(block, TextureMapping.cube((Block)block), this.modelOutput))));
    }

    public void createGlowCube(Block block) {
        this.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)GLOW_CUBE.create(block, FrostTextureMappings.glowCube(block), this.modelOutput))));
    }

    public void createGrassLikeFrostBlock(Block block, Block dirt) {
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)dirt)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side")).copySlot(TextureSlot.BOTTOM, TextureSlot.PARTICLE).put(FrostTextureMappings.OVERLAY, TextureMapping.getBlockTexture((Block)block, (String)"_side_overlay"));
        this.blockStateOutput.accept(FrBlockstateModelProvider.createSimpleBlock(block, FrostModelTemplates.GRASS_BLOCK.extend().renderType("cutout_mipped").build().create(block, texturemapping, this.modelOutput)));
        this.registerSimpleTintedItemModel(block, ModelLocationUtils.getModelLocation((Block)block), (ItemTintSource)new GrassColorSource());
    }

    public void createGrassLikeFrostStoneBlock(Block block, Block dirt) {
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)dirt)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side")).copySlot(TextureSlot.BOTTOM, TextureSlot.PARTICLE).copySlot(TextureSlot.SIDE, FrostTextureMappings.OVERLAY);
        this.blockStateOutput.accept(FrBlockstateModelProvider.createSimpleBlock(block, FrostModelTemplates.GRASS_BLOCK.extend().renderType("cutout").build().create(block, texturemapping, this.modelOutput)));
        this.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block));
    }

    public void createEgg(Block block) {
        this.registerSimpleFlatItemModel(block.asItem());
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)BlockStateProperties.EGGS, (Property)BlockStateProperties.HATCH).generate((p_408968_, p_408969_) -> FrBlockstateModelProvider.createRotatedVariants((Variant)this.createEggModel(block, (Integer)p_408968_, (Integer)p_408969_)))));
    }

    public void createBlockEgg(Block block) {
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)BlockStateProperties.EGGS, (Property)BlockStateProperties.HATCH).generate((p_408968_, p_408969_) -> FrBlockstateModelProvider.createRotatedVariants((Variant)this.createEggModel(block, (Integer)p_408968_, (Integer)p_408969_)))));
        this.registerSimpleItemModel(block.asItem(), ModelLocationUtils.getModelLocation((Block)block));
    }

    public Variant createEggModel(Block block, Integer p_386499_, Integer p_387511_) {
        switch (p_387511_) {
            case 0: {
                return this.createEggModel(block, p_386499_, "", TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)block)));
            }
            case 1: {
                return this.createEggModel(block, p_386499_, "slightly_cracked_", TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)block)));
            }
            case 2: {
                return this.createEggModel(block, p_386499_, "very_cracked_", TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)block)));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String getBlockName(Block p_387523_) {
        ResourceLocation resourcelocation = BuiltInRegistries.BLOCK.getKey((Object)p_387523_);
        return resourcelocation.getPath();
    }

    public Variant createEggModel(Block block, int p_387392_, String p_387935_, TextureMapping p_388813_) {
        switch (p_387392_) {
            case 1: {
                return FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.TURTLE_EGG.create(FrostRealm.prefix(p_387935_ + FrBlockstateModelProvider.getBlockName(block)).withPrefix("block/"), p_388813_, this.modelOutput));
            }
            case 2: {
                return FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.TWO_TURTLE_EGGS.create(FrostRealm.prefix("two_" + p_387935_ + FrBlockstateModelProvider.getBlockName(block)).withPrefix("block/"), p_388813_, this.modelOutput));
            }
            case 3: {
                return FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.THREE_TURTLE_EGGS.create(FrostRealm.prefix("three_" + p_387935_ + FrBlockstateModelProvider.getBlockName(block)).withPrefix("block/"), p_388813_, this.modelOutput));
            }
            case 4: {
                return FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FOUR_TURTLE_EGGS.create(FrostRealm.prefix("four_" + p_387935_ + FrBlockstateModelProvider.getBlockName(block)).withPrefix("block/"), p_388813_, this.modelOutput));
            }
        }
        throw new UnsupportedOperationException();
    }

    public void createFrostFarmland() {
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.FROZEN_DIRT.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.FROZEN_FARMLAND.get())));
        TextureMapping texturemapping1 = new TextureMapping().put(TextureSlot.DIRT, TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.FROZEN_DIRT.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.FROZEN_FARMLAND.get()), (String)"_moist"));
        MultiVariant resourcelocation = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.FARMLAND.create((Block)FrostBlocks.FROZEN_FARMLAND.get(), texturemapping, this.modelOutput));
        MultiVariant resourcelocation1 = FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.FARMLAND.create(TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.FROZEN_FARMLAND.get()), (String)"_moist"), texturemapping1, this.modelOutput));
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)FrostBlocks.FROZEN_FARMLAND.get())).with(BlockModelGenerators.createEmptyOrFullDispatch((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7), (MultiVariant)resourcelocation1, (MultiVariant)resourcelocation)));
    }

    public static MultiVariantGenerator createSimpleBlock(Block p_387997_, ResourceLocation p_388814_) {
        return MultiVariantGenerator.dispatch((Block)p_387997_, (MultiVariant)FrBlockstateModelProvider.plainVariant((ResourceLocation)p_388814_));
    }

    public void createFrostPortalBlock() {
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)FrostBlocks.FROST_PORTAL.get())).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockStateProperties.HORIZONTAL_AXIS).select((Comparable)Direction.Axis.X, (Object)FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)FrostBlocks.FROST_PORTAL.get()), (String)"_ns"))).select((Comparable)Direction.Axis.Z, (Object)FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)FrostBlocks.FROST_PORTAL.get()), (String)"_ew")))));
    }

    public void createPointedIce(BlockModelGenerators generator) {
        PropertyDispatch.C2 c2 = PropertyDispatch.initial((Property)BlockStateProperties.VERTICAL_DIRECTION, (Property)BlockStateProperties.DRIPSTONE_THICKNESS);
        for (DripstoneThickness dripstonethickness : DripstoneThickness.values()) {
            c2.select((Comparable)Direction.UP, (Comparable)dripstonethickness, (Object)this.createPointedDripstoneVariant(Direction.UP, dripstonethickness));
        }
        for (DripstoneThickness dripstonethickness1 : DripstoneThickness.values()) {
            c2.select((Comparable)Direction.DOWN, (Comparable)dripstonethickness1, (Object)this.createPointedDripstoneVariant(Direction.DOWN, dripstonethickness1));
        }
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)FrostBlocks.POINTED_ICE.get())).with((PropertyDispatch)c2));
        generator.registerSimpleFlatItemModel((Block)FrostBlocks.POINTED_ICE.get(), "_up_tip");
    }

    public MultiVariant createPointedDripstoneVariant(Direction p_387068_, DripstoneThickness p_388190_) {
        String s = "_" + p_387068_.getSerializedName() + "_" + p_388190_.getSerializedName();
        TextureMapping texturemapping = TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)FrostBlocks.POINTED_ICE.get()), (String)s));
        return FrBlockstateModelProvider.plainVariant((ResourceLocation)ModelTemplates.POINTED_DRIPSTONE.extend().renderType("cutout").build().createWithSuffix((Block)FrostBlocks.POINTED_ICE.get(), s, texturemapping, this.modelOutput));
    }

    public void createCropBlock(Block p_387553_, Property<Integer> p_386757_, int ... p_388514_) {
        this.registerSimpleFlatItemModel(p_387553_.asItem());
        if (p_386757_.getPossibleValues().size() != p_388514_.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)p_387553_).with(PropertyDispatch.initial(p_386757_).generate(arg_0 -> this.lambda$createCropBlock$3(p_388514_, (Int2ObjectMap)int2objectmap, p_387553_, arg_0))));
    }

    public MultiVariant createSideFireModels(Block p_387079_) {
        return FrBlockstateModelProvider.variants((Variant[])new Variant[]{FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_SIDE.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387079_, (String)"_side0"), TextureMapping.fire0((Block)p_387079_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_SIDE.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387079_, (String)"_side1"), TextureMapping.fire1((Block)p_387079_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_SIDE_ALT.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387079_, (String)"_side_alt0"), TextureMapping.fire0((Block)p_387079_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_SIDE_ALT.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387079_, (String)"_side_alt1"), TextureMapping.fire1((Block)p_387079_), this.modelOutput))});
    }

    public MultiVariant createTopFireModels(Block p_387163_) {
        return FrBlockstateModelProvider.variants((Variant[])new Variant[]{FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_UP.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387163_, (String)"_up0"), TextureMapping.fire0((Block)p_387163_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_UP.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387163_, (String)"_up1"), TextureMapping.fire1((Block)p_387163_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_UP_ALT.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387163_, (String)"_up_alt0"), TextureMapping.fire0((Block)p_387163_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_UP_ALT.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387163_, (String)"_up_alt1"), TextureMapping.fire1((Block)p_387163_), this.modelOutput))});
    }

    public MultiVariant createFloorFireModels(Block p_387402_) {
        return FrBlockstateModelProvider.variants((Variant[])new Variant[]{FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_FLOOR.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387402_, (String)"_floor0"), TextureMapping.fire0((Block)p_387402_), this.modelOutput)), FrBlockstateModelProvider.plainModel((ResourceLocation)ModelTemplates.FIRE_FLOOR.extend().renderType("cutout").build().create(ModelLocationUtils.getModelLocation((Block)p_387402_, (String)"_floor1"), TextureMapping.fire1((Block)p_387402_), this.modelOutput))});
    }

    public void createFrostFire() {
        MultiVariant multivariant = this.createFloorFireModels((Block)FrostBlocks.FROST_FIRE.get());
        MultiVariant multivariant1 = this.createSideFireModels((Block)FrostBlocks.FROST_FIRE.get());
        this.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)FrostBlocks.FROST_FIRE.get())).with(multivariant).with(multivariant1).with(multivariant1.with(Y_ROT_90)).with(multivariant1.with(Y_ROT_180)).with(multivariant1.with(Y_ROT_270)));
    }

    private /* synthetic */ MultiVariant lambda$createCropBlock$3(int[] p_388514_, Int2ObjectMap int2objectmap, Block p_387553_, Integer p_408977_) {
        int i = p_388514_[p_408977_];
        return FrBlockstateModelProvider.plainVariant((ResourceLocation)((ResourceLocation)int2objectmap.computeIfAbsent(i, p_387308_ -> this.createSuffixedVariant(p_387553_, "_" + p_387308_, (ModelTemplate)ModelTemplates.CROP.extend().renderType("cutout").build(), TextureMapping::crop))));
    }
}

