/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.resource;

import baguchan.frostrealm.world.gen.FrostNoiseRouterData;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FrostDensityFunctions {
    public static final ResourceKey<DensityFunction> UNDERGROUND = FrostDensityFunctions.createKey("underground");

    private static ResourceKey<DensityFunction> createVannilaKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    private static ResourceKey<DensityFunction> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name));
    }

    public static void bootstrap(BootstrapContext<DensityFunction> context) {
        HolderGetter noiseHolderGetter = context.lookup(Registries.NOISE);
        HolderGetter density = context.lookup(Registries.DENSITY_FUNCTION);
        FrostNoiseRouterData.bootstrapDensity(context);
        context.register(UNDERGROUND, (Object)FrostNoiseRouterData.underground((HolderGetter<DensityFunction>)density, (HolderGetter<NormalNoise.NoiseParameters>)noiseHolderGetter, FrostDensityFunctions.getFunction((HolderGetter<DensityFunction>)density, FrostNoiseRouterData.SLOPED_CHEESE)));
        context.register(FrostNoiseRouterData.PILLARS, (Object)FrostDensityFunctions.pillars((HolderGetter<NormalNoise.NoiseParameters>)noiseHolderGetter));
    }

    private static DensityFunction pillars(HolderGetter<NormalNoise.NoiseParameters> p_255985_) {
        double d0 = 25.0;
        double d1 = 0.3;
        DensityFunction densityfunction = DensityFunctions.noise((Holder)p_255985_.getOrThrow(Noises.PILLAR), (double)25.0, (double)0.3);
        DensityFunction densityfunction1 = DensityFunctions.mappedNoise((Holder)p_255985_.getOrThrow(Noises.PILLAR_RARENESS), (double)0.0, (double)-2.0);
        DensityFunction densityfunction2 = DensityFunctions.mappedNoise((Holder)p_255985_.getOrThrow(Noises.PILLAR_THICKNESS), (double)0.0, (double)1.25);
        DensityFunction densityfunction3 = DensityFunctions.add((DensityFunction)DensityFunctions.mul((DensityFunction)densityfunction, (DensityFunction)DensityFunctions.constant((double)2.0)), (DensityFunction)densityfunction1);
        return DensityFunctions.cacheOnce((DensityFunction)DensityFunctions.mul((DensityFunction)densityfunction3, (DensityFunction)densityfunction2.cube()));
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> p_256312_, ResourceKey<DensityFunction> p_256077_) {
        return new DensityFunctions.HolderHolder((Holder)p_256312_.getOrThrow(p_256077_));
    }
}

