/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.resource;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.registry.FrostBiomeSources;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.world.biome.FrostrealmBiomeBuilder;
import baguchan.frostrealm.world.gen.FrostChunkGenerator;
import baguchan.frostrealm.world.gen.FrostNoiseRouterData;
import baguchan.frostrealm.world.gen.FrostSurfaceRuleData;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class FrostDimensionSettings {
    public static final ResourceLocation EFFECTS = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"renderer");
    static final NoiseSettings FROST_NOISE_SETTINGS = FrostDimensionSettings.create(-80, 384, 1, 2);
    public static final ResourceKey<NoiseGeneratorSettings> FROSTREALM_NOISE = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frostrealm_noise"));
    public static final ResourceKey<LevelStem> FROSTREALM_LEVEL_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)FrostRealm.prefix("frostrealm"));

    public static NoiseGeneratorSettings frostrealmNoise(BootstrapContext<NoiseGeneratorSettings> p_256365_) {
        return new NoiseGeneratorSettings(FROST_NOISE_SETTINGS, ((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState(), Blocks.WATER.defaultBlockState(), FrostNoiseRouterData.frostrealm((HolderGetter<DensityFunction>)p_256365_.lookup(Registries.DENSITY_FUNCTION), (HolderGetter<NormalNoise.NoiseParameters>)p_256365_.lookup(Registries.NOISE)), FrostSurfaceRuleData.frostrealm(), new FrostrealmBiomeBuilder().spawnTarget(), 63, false, true, false, false);
    }

    public static void bootstrapNoise(BootstrapContext<NoiseGeneratorSettings> p_256365_) {
        p_256365_.register(FROSTREALM_NOISE, (Object)FrostDimensionSettings.frostrealmNoise(p_256365_));
    }

    public static void bootstrapDimensionType(BootstrapContext<DimensionType> p_256376_) {
        p_256376_.register(FrostDimensions.FROSTREALM_TYPE, (Object)FrostDimensionSettings.frostDimType());
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> context) {
        HolderGetter chunk = context.lookup(Registries.CHUNK_GENERATOR);
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseGenSettings = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter multiNoiseBiomeSourceParameterLists = context.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        Holder.Reference reference = multiNoiseBiomeSourceParameterLists.getOrThrow(FrostBiomeSources.FROSTREALM);
        FrostChunkGenerator wrappedChunkGenerator = new FrostChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)reference), (Holder<NoiseGeneratorSettings>)noiseGenSettings.getOrThrow(FROSTREALM_NOISE));
        LevelStem stem = new LevelStem((Holder)dimTypes.getOrThrow(FrostDimensions.FROSTREALM_TYPE), (ChunkGenerator)wrappedChunkGenerator);
        context.register(FROSTREALM_LEVEL_STEM, (Object)stem);
    }

    private static DimensionType frostDimType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, -64, 384, 384, BlockTags.INFINIBURN_OVERWORLD, FrostRealm.prefix("renderer"), 0.0f, Optional.of(192), new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 0));
    }

    public static NoiseSettings create(int p_224526_, int p_224527_, int p_224528_, int p_224529_) {
        NoiseSettings noisesettings = new NoiseSettings(p_224526_, p_224527_, p_224528_, p_224529_);
        return noisesettings;
    }
}

