/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data.resource.registries;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.api.entity.WolfflueVariant;
import baguchan.frostrealm.registry.FrostBiomes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class WolfflueVariants {
    public static final ResourceKey<Registry<WolfflueVariant>> WOLFFLUE_VARIANT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"wolfflue_variant"));
    public static final ResourceKey<WolfflueVariant> FROST = WolfflueVariants.createKey("frost");
    public static final ResourceKey<WolfflueVariant> SNOW = WolfflueVariants.createKey("snow");
    public static final ResourceKey<WolfflueVariant> YUZUKI = WolfflueVariants.createKey("yuzuki");
    public static final ResourceKey<WolfflueVariant> DEFAULT = FROST;

    private static ResourceKey<WolfflueVariant> createKey(String name) {
        return ResourceKey.create(WOLFFLUE_VARIANT_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name));
    }

    static void register(BootstrapContext<WolfflueVariant> context, ResourceKey<WolfflueVariant> key, String name, ResourceKey<Biome> biomeResourceKey) {
        WolfflueVariants.register(context, key, name, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.BIOME).getOrThrow(biomeResourceKey)}));
    }

    static void register(BootstrapContext<WolfflueVariant> context, ResourceKey<WolfflueVariant> key, String name, TagKey<Biome> biomeTag) {
        WolfflueVariants.register(context, key, name, (HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(biomeTag));
    }

    static void register(BootstrapContext<WolfflueVariant> context, ResourceKey<WolfflueVariant> key, String name, HolderSet<Biome> biomeHolderSet) {
        ResourceLocation resourcelocation = FrostRealm.prefix("entity/wolfflue/" + name);
        ResourceLocation resourcelocation2 = FrostRealm.prefix("entity/wolfflue/" + name + "_angry");
        context.register(key, (Object)new WolfflueVariant(resourcelocation, resourcelocation2, biomeHolderSet));
    }

    public static Holder<WolfflueVariant> getSpawnVariant(RegistryAccess p_332694_, Holder<Biome> p_332773_) {
        Registry registry = p_332694_.lookupOrThrow(WOLFFLUE_VARIANT_REGISTRY_KEY);
        return (Holder)registry.listElements().filter(p_332674_ -> ((WolfflueVariant)p_332674_.value()).biomes().contains(p_332773_)).findFirst().or(() -> registry.get(DEFAULT)).or(() -> ((Registry)registry).getAny()).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<WolfflueVariant> context) {
        WolfflueVariants.register(context, FROST, "wolfflue", FrostBiomes.FRIGID_FOREST);
        WolfflueVariants.register(context, SNOW, "wolfflue_snow", FrostBiomes.TUNDRA);
        WolfflueVariants.register(context, YUZUKI, "wolfflue_yuzuki", (HolderSet<Biome>)HolderSet.empty());
    }
}

