/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity;

import baguchan.frostrealm.message.UpdateMultipartPacket;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class FrostPart<T extends Entity>
extends PartEntity<T> {
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.defineId(FrostPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private EntityDimensions size;
    protected int newPosRotationIncrements;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    public float renderYawOffset;
    public float prevRenderYawOffset;
    private float appliedScale = 1.0f;

    public FrostPart(T p_31014_, float width, float height) {
        super(p_31014_);
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_325943_) {
        p_325943_.define(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public float getScale() {
        return ((Float)this.entityData.get(DATA_SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.entityData.set(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public void setSize(EntityDimensions size) {
        this.size = size;
        this.refreshDimensions();
    }

    public EntityDimensions getRawSize() {
        return this.size;
    }

    public void setPositionAndRotationDirect(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public void tick() {
        this.updateLastPos();
        super.tick();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.getX() + (this.interpTargetX - this.getX()) / (double)this.newPosRotationIncrements;
            double d2 = this.getY() + (this.interpTargetY - this.getY()) / (double)this.newPosRotationIncrements;
            double d4 = this.getZ() + (this.interpTargetZ - this.getZ()) / (double)this.newPosRotationIncrements;
            double d6 = Mth.wrapDegrees((double)(this.interpTargetYaw - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d6 / (double)this.newPosRotationIncrements));
            this.setXRot((float)((double)this.getXRot() + (this.interpTargetPitch - (double)this.getXRot()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.setPos(d0, d2, d4);
            this.setRot(this.getYRot(), this.getXRot());
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        float f6 = this.getScale();
        if (f6 != this.appliedScale) {
            this.appliedScale = f6;
            this.refreshDimensions();
        }
    }

    public boolean hurtServer(ServerLevel p_376804_, DamageSource p_376155_, float p_376892_) {
        return false;
    }

    public final void updateLastPos() {
        this.snapTo(this.getX(), this.getY(), this.getZ());
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        ++this.tickCount;
    }

    protected void readAdditionalSaveData(ValueInput p_31025_) {
    }

    protected void addAdditionalSaveData(ValueOutput p_31028_) {
    }

    public boolean isCurrentlyGlowing() {
        return this.getParent().isCurrentlyGlowing();
    }

    public boolean isInvisible() {
        return this.getParent().isInvisible();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return this.getParent().interact(player, hand);
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getParent().getPickResult();
    }

    public boolean is(Entity p_31031_) {
        return this == p_31031_ || this.getParent() == p_31031_;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        throw new UnsupportedOperationException();
    }

    public UpdateMultipartPacket.PartDataHolder writeData() {
        return new UpdateMultipartPacket.PartDataHolder(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), this.getRawSize().width(), this.getRawSize().height(), this.getRawSize().fixed(), this.getEntityData().packDirty());
    }

    public void readData(UpdateMultipartPacket.PartDataHolder data) {
        Vec3 vec = new Vec3(data.x(), data.y(), data.z());
        this.setPositionAndRotationDirect(vec.x(), vec.y(), vec.z(), data.yRot(), data.xRot(), 3);
        float w = data.width();
        float h = data.height();
        this.setSize(data.fixed() ? EntityDimensions.fixed((float)w, (float)h) : EntityDimensions.scalable((float)w, (float)h));
        if (data.data() != null) {
            this.getEntityData().assignValues(data.data());
        }
        this.refreshDimensions();
    }

    public EntityDimensions getDimensions(Pose p_31023_) {
        return this.getRawSize().scale(this.getScale());
    }

    public boolean shouldBeSaved() {
        return false;
    }
}

