/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Ferret
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Ferret.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final DyeColor DEFAULT_COLLAR_COLOR = DyeColor.RED;
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_348295_ -> {
        EntityType entitytype = p_348295_.getType();
        return entitytype == FrostEntities.SNOWPILE_QUAIL.get();
    };
    private float runningScale;
    private float runningScaleO;

    public Ferret(EntityType<? extends Ferret> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326027_) {
        super.defineSynchedData(p_326027_);
        p_326027_.define(DATA_COLLAR_COLOR, (Object)DyeColor.RED.getId());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.35f, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.85f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, (living, serverLevel) -> PREY_SELECTOR.test(living)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.26f).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void addAdditionalSaveData(ValueOutput p_30418_) {
        super.addAdditionalSaveData(p_30418_);
        p_30418_.store("CollarColor", DyeColor.LEGACY_ID_CODEC, (Object)this.getCollarColor());
    }

    public void readAdditionalSaveData(ValueInput p_30402_) {
        super.readAdditionalSaveData(p_30402_);
        this.setCollarColor(p_30402_.read("CollarColor", DyeColor.LEGACY_ID_CODEC).orElse(DEFAULT_COLLAR_COLOR));
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide() || this.isBaby() && this.isFood(itemstack)) {
            if (this.isTame()) {
                InteractionResult interactionresult;
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(f);
                    itemstack.consume(1, (LivingEntity)p_30412_);
                    this.gameEvent((Holder)GameEvent.EAT);
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (item instanceof DyeItem) {
                    DyeItem dyeitem = (DyeItem)item;
                    if (this.isOwnedBy((LivingEntity)p_30412_)) {
                        DyeColor dyecolor = dyeitem.getDyeColor();
                        if (dyecolor != this.getCollarColor()) {
                            this.setCollarColor(dyecolor);
                            itemstack.consume(1, (LivingEntity)p_30412_);
                            return InteractionResult.SUCCESS;
                        }
                        return super.mobInteract(p_30412_, p_30413_);
                    }
                }
                if (!(interactionresult = super.mobInteract(p_30412_, p_30413_)).consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.SUCCESS.withoutItem();
                }
                return interactionresult;
            }
            if (!this.level().isClientSide() && this.isFood(itemstack) && this.getTarget() != p_30412_) {
                itemstack.consume(1, (LivingEntity)p_30412_);
                this.tryToTame(p_30412_);
                return InteractionResult.SUCCESS_SERVER;
            }
            return super.mobInteract(p_30412_, p_30413_);
        }
        boolean flag = this.isOwnedBy((LivingEntity)p_30412_) || this.isTame() || itemstack.is(Items.BONE) && !this.isTame() && this.getTarget() != p_30412_;
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    private void tryToTame(Player p_333736_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_333736_)) {
            this.tame(p_333736_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public static boolean checkWolfSpawnRules(EntityType<Ferret> p_218292_, LevelAccessor p_218293_, EntitySpawnReason p_218294_, BlockPos p_218295_, RandomSource p_218296_) {
        return p_218293_.getBlockState(p_218295_.below()).is(FrostTags.Blocks.ANIMAL_SPAWNABLE) && Ferret.isBrightEnoughToSpawn((BlockAndTintGetter)p_218293_, (BlockPos)p_218295_);
    }

    private void setupAnimationStates() {
        this.runningScaleO = this.runningScale;
        if (this.isMoving()) {
            this.runningScale = this.isDashing() ? Mth.clamp((float)(this.runningScale + 0.1f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.runningScale - 0.1f), (float)0.0f, (float)1.0f);
        }
    }

    private boolean isDashing() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 0.02;
    }

    private boolean isMoving() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
    }

    public float getRunningScale(float p_29570_) {
        return Mth.lerp((float)p_29570_, (float)this.runningScaleO, (float)this.runningScale);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor p_30398_) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)p_30398_.getId());
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(FrostTags.Items.FERRET_FOODS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.FERRET.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    public int getMaxSpawnClusterSize() {
        return 6;
    }

    public boolean isMaxGroupSizeReached(int p_21489_) {
        return false;
    }

    public boolean canMate(Animal p_30392_) {
        if (p_30392_ == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(p_30392_ instanceof Ferret)) {
            return false;
        }
        Ferret ferret = (Ferret)p_30392_;
        if (!ferret.isTame()) {
            return false;
        }
        return !ferret.isInSittingPose() && this.isInLove() && ferret.isInLove();
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand) {
            return false;
        }
        if (p_30389_ instanceof Ferret) {
            Ferret ferret = (Ferret)p_30389_;
            return !ferret.isTame() || ferret.getOwner() != p_30390_;
        }
        if (p_30389_ instanceof Player) {
            Player player1;
            Player player = (Player)p_30389_;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
    }
}

