/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.goal.SeekShelterEvenBlizzardGoal;
import baguchan.frostrealm.entity.path.FrostPathNavigation;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostSounds;
import baguchi.bagus_lib.entity.goal.TimeConditionGoal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Marmot
extends FrostAnimal {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.MARMOT.get()).getDimensions().scale(0.5f).withEyeHeight(0.2f);
    private static final UniformInt TIME_BETWEEN_STANDS = UniformInt.of((int)300, (int)600);
    private static final UniformInt TIME_BETWEEN_STANDS_COOLDOWN = UniformInt.of((int)600, (int)1200);
    private static final EntityDataAccessor<Boolean> IS_STANDING = SynchedEntityData.defineId(Marmot.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Marmot(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.3f));
        this.goalSelector.addGoal(2, (Goal)new SeekShelterEvenBlizzardGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new StandingGoal(this, TIME_BETWEEN_STANDS_COOLDOWN, TIME_BETWEEN_STANDS));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)1.1f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(ItemTags.SMALL_FLOWERS);
    }

    protected PathNavigation createNavigation(Level p_33348_) {
        return new FrostPathNavigation((Mob)this, p_33348_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_STANDING, (Object)false);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(IS_STANDING, (Object)standing);
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(IS_STANDING);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isStanding() ? (SoundEvent)FrostSounds.MARMOT_IDLE.get() : super.getAmbientSound();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return (SoundEvent)FrostSounds.MARMOT_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)FrostSounds.MARMOT_DEATH.get();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.MARMOT.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public static class StandingGoal
    extends TimeConditionGoal {
        public final Marmot marmot;

        public StandingGoal(Marmot marmot, UniformInt uniformInt, UniformInt uniformInt2) {
            super((Mob)marmot, uniformInt, uniformInt2);
            this.marmot = marmot;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean isMatchCondition() {
            return this.marmot.getTarget() == null;
        }

        public void start() {
            super.start();
            this.marmot.setStanding(true);
            this.marmot.getNavigation().stop();
        }

        public void stop() {
            super.stop();
            this.marmot.setStanding(false);
        }
    }
}

