/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.animal;

import baguchan.frostrealm.entity.goal.RandomMoveGoal;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.registry.FrostTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Seal
extends Animal {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)FrostEntities.SEAL.get()).getDimensions().scale(0.5f).withEyeHeight(0.25f);
    @javax.annotation.Nullable
    protected RandomStrollGoal randomStrollGoal;
    public final AnimationState fartAnimationState = new AnimationState();
    public int gasTick;
    private int destroyBlocksTick;

    public Seal(EntityType<? extends Seal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 0.9f, true);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DOOR_IRON_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_WOOD_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_OPEN, -1.0f);
    }

    public EntityDimensions getDefaultDimensions(Pose p_316516_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_316516_);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.randomStrollGoal = new RandomMoveGoal((PathfinderMob)this, 1.0, 30);
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this){

            public boolean canUse() {
                return Seal.this.getAirSupply() < 600;
            }
        });
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.3f));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.15, item -> item.is(ItemTags.FISHES), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 8.0f, 1.25, (double)1.35f));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(7, (Goal)this.randomStrollGoal);
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, true));
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(ItemTags.FISHES);
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.gasTick > 0) {
                --this.gasTick;
            }
            if (this.gasTick <= 0 && this.fartAnimationState.isStarted()) {
                this.fartAnimationState.stop();
            }
        }
    }

    public void playAmbientSound() {
        if (this.random.nextInt(6) == 0) {
            this.makeSound((SoundEvent)FrostSounds.SEAL_FART.get());
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)61);
            }
        } else {
            this.makeSound(this.getAmbientSound());
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)FrostSounds.SEAL_IDLE.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return (SoundEvent)FrostSounds.SEAL_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)FrostSounds.SEAL_DEATH.get();
    }

    public void handleEntityEvent(byte p_27562_) {
        if (p_27562_ == 61) {
            this.fartAnimationState.start(this.tickCount);
            this.gasTick = 80;
        } else {
            super.handleEntityEvent(p_27562_);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_28332_, DifficultyInstance p_28333_, EntitySpawnReason p_28334_, @javax.annotation.Nullable SpawnGroupData p_28335_) {
        boolean flag = false;
        if (p_28335_ instanceof AgeableMob.AgeableMobGroupData) {
            if (((AgeableMob.AgeableMobGroupData)p_28335_).getGroupSize() >= 2) {
                flag = true;
            }
        } else {
            p_28335_ = new AgeableMob.AgeableMobGroupData(true);
        }
        if (flag) {
            this.setAge(-24000);
        }
        this.setAirSupply(this.getMaxAirSupply());
        this.setXRot(0.0f);
        return super.finalizeSpawn(p_28332_, p_28333_, p_28334_, p_28335_);
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        if (p_27574_.getBlockState(p_27573_.below()).is(FrostTags.Blocks.SEAL_SPAWNABLE) || p_27574_.getBlockState(p_27573_.below()).is(Blocks.SNOW_BLOCK)) {
            return 12.0f;
        }
        return p_27574_.getBlockState(p_27573_).is(Blocks.WATER) ? 10.0f : p_27574_.getPathfindingCostFromLightLevels(p_27573_) - 0.5f;
    }

    public static boolean checkSealSpawnRules(EntityType<? extends Animal> p_218105_, LevelAccessor p_218106_, EntitySpawnReason p_218107_, BlockPos p_218108_, RandomSource p_218109_) {
        return p_218106_.getBlockState(p_218108_.below()).is(FrostTags.Blocks.SEAL_SPAWNABLE) && Seal.isBrightEnoughToSpawn((BlockAndTintGetter)p_218106_, (BlockPos)p_218108_);
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    protected PathNavigation createNavigation(Level p_27480_) {
        return new AmphibiousPathNavigation((Mob)this, p_27480_);
    }

    public void travel(Vec3 p_27490_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), p_27490_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(p_27490_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.24);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)FrostEntities.SEAL.get()).create((Level)p_146743_, EntitySpawnReason.BREEDING);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            if (this.isInWater()) {
                if (this.randomStrollGoal != null) {
                    this.randomStrollGoal.setInterval(10);
                }
            } else if (this.randomStrollGoal != null) {
                this.randomStrollGoal.setInterval(180);
            }
        }
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
        }
        if (this.verticalCollision && this.isInWater() && this.destroyBlocksTick == 0 && EventHooks.canEntityGrief((ServerLevel)serverLevel, (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.getBoundingBox().inflate(0.2);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                Block block = blockstate.getBlock();
                if (blockstate.is(Blocks.ICE)) {
                    boolean bl = flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
                }
                if (!flag) continue;
                this.level().setBlockAndUpdate(blockpos, Blocks.WATER.defaultBlockState());
            }
            this.destroyBlocksTick = 20;
        }
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int p_28389_) {
        return this.getMaxAirSupply();
    }
}

