/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.boss;

import baguchan.frostrealm.entity.goal.SeekerAttackGoal;
import baguchan.frostrealm.entity.goal.SeekerBreathGoal;
import baguchan.frostrealm.entity.hostile.LesserWarrior;
import baguchan.frostrealm.registry.FrostEntityDatas;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostSounds;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Seeker
extends Monster {
    private static final EntityDataAccessor<SeekerState> STATE = SynchedEntityData.defineId(Seeker.class, (EntityDataSerializer)((EntityDataSerializer)FrostEntityDatas.SEEKER_STATE.get()));
    public int attackAnimationTick;
    public static final int attackAnimationLength = 40;
    public static final int attackAnimationActionPoint = 11;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState preAttackAnimationState = new AnimationState();
    public final AnimationState stopAttackAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public final AnimationState breathAnimationState = new AnimationState();
    public final AnimationState breathPreAnimationState = new AnimationState();
    public final AnimationState breathStopAnimationState = new AnimationState();
    private long inStateTicks = 0L;
    private long noSpecialAttackTime = 0L;

    public Seeker(EntityType<? extends Seeker> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.xpReward = 200;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new SeekerBreathGoal(this));
        this.goalSelector.addGoal(4, (Goal)new SeekerAttackGoal(this, 1.2, 11, 40, 60.0));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public void addAdditionalSaveData(ValueOutput p_21484_) {
        super.addAdditionalSaveData(p_21484_);
        p_21484_.putLong("NoAttackTime", this.noSpecialAttackTime);
    }

    public void readAdditionalSaveData(ValueInput p_21450_) {
        super.readAdditionalSaveData(p_21450_);
        this.noSpecialAttackTime = p_21450_.getLongOr("NoAttackTime", 0L);
    }

    public long getNoSpecialAttackTime() {
        return this.noSpecialAttackTime;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326186_) {
        super.defineSynchedData(p_326186_);
        p_326186_.define(STATE, (Object)SeekerState.IDLE);
    }

    public SeekerState getState() {
        return (SeekerState)((Object)this.entityData.get(STATE));
    }

    public void setState(SeekerState state) {
        this.entityData.set(STATE, (Object)state);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.MAX_HEALTH, 300.0).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.SAFE_FALL_DISTANCE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)FrostSounds.SEEKER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33034_) {
        return (SoundEvent)FrostSounds.SEEKER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)FrostSounds.SEEKER_DEATH.get();
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_316145_) {
        if (STATE.equals(p_316145_)) {
            this.inStateTicks = 0L;
            this.setupAnimationStates();
        }
        super.onSyncedDataUpdated(p_316145_);
    }

    public boolean isEnoughNoAttack() {
        return this.noSpecialAttackTime > 100L;
    }

    public boolean shouldSwitchState() {
        return !this.getState().isLoop() && this.inStateTicks > (long)this.getState().animationDuration();
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.attackAnimationTick < 40) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= 40) {
                this.attackAnimationState.stop();
                if (this.isAggressive()) {
                    this.preAttackAnimationState.startIfStopped(this.tickCount);
                }
            }
        } else if (this.isAggressive() && this.getState() == SeekerState.IDLE) {
            this.setState(SeekerState.PRE_ATTACK);
        } else if (!this.isAggressive() && this.getState() == SeekerState.PRE_ATTACK) {
            this.setState(SeekerState.STOP_ATTACK);
        } else if (this.shouldSwitchState()) {
            if (this.getState() == SeekerState.BREATH_PRE) {
                this.setState(SeekerState.BREATH);
            } else if (this.isAggressive()) {
                this.setState(SeekerState.PRE_ATTACK);
            } else {
                this.setState(SeekerState.IDLE);
            }
        }
        this.noSpecialAttackTime = this.isAggressive() ? ++this.noSpecialAttackTime : --this.noSpecialAttackTime;
        ++this.inStateTicks;
    }

    private void setupAnimationStates() {
        this.preAttackAnimationState.stop();
        this.stopAttackAnimationState.stop();
        this.breathAnimationState.stop();
        this.breathPreAnimationState.stop();
        this.breathStopAnimationState.stop();
        switch (this.getState().ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.preAttackAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case 2: {
                this.stopAttackAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case 4: {
                this.breathPreAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case 5: {
                this.breathAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case 6: {
                this.breathStopAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (this.getState() == SeekerState.BREATH && this.isAlive()) {
            Vec3 look = this.getViewVector(1.0f);
            double dist = 3.0;
            double px = this.getX() + look.x() * 1.5;
            double py = this.getEyeY() - 0.5;
            double pz = this.getZ() + look.z() * 1.5;
            for (int i = 0; i < 10; ++i) {
                double dx = look.x();
                double dy = look.y();
                double dz = look.z();
                double spread = 64.0 + this.getRandom().nextDouble() * 2.5;
                double velocity = 2.0 + this.getRandom().nextDouble() * 0.15;
                dx += this.getRandom().nextGaussian() * 0.0075 * spread;
                dy += this.getRandom().nextGaussian() * 0.0075 * spread;
                dz += this.getRandom().nextGaussian() * 0.0075 * spread;
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 4) {
            this.attackAnimationState.start(this.tickCount);
            this.preAttackAnimationState.stop();
            this.stopAttackAnimationState.stop();
            this.attackAnimationTick = 0;
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        return super.considersEntityAsAlly(p_360600_) || p_360600_ instanceof Seeker || p_360600_ instanceof LesserWarrior;
    }

    protected void tickDeath() {
        if (this.level().isClientSide() && this.deathTime == 0) {
            this.deathAnimationState.start(this.tickCount);
            this.attackAnimationState.stop();
        }
        if (++this.deathTime >= 60 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34717_, DifficultyInstance p_34718_, EntitySpawnReason p_361787_, @javax.annotation.Nullable SpawnGroupData p_34720_) {
        RandomSource randomsource = p_34717_.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, p_34718_);
        this.populateDefaultEquipmentEnchantments(p_34717_, randomsource, p_34718_);
        return super.finalizeSpawn(p_34717_, p_34718_, p_361787_, p_34720_);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218949_, DifficultyInstance p_218950_) {
        ItemStack spear = new ItemStack((ItemLike)FrostItems.FROST_SPEAR.get());
        this.setItemSlot(EquipmentSlot.MAINHAND, spear);
        this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_21372_) {
        boolean flag = super.doHurtTarget(serverLevel, p_21372_);
        if (flag && this.getMainHandItem().is((Item)FrostItems.FROST_SPEAR.get())) {
            int freezeTick = p_21372_.canFreeze() ? 100 : 40;
            p_21372_.setTicksFrozen(Mth.clamp((int)(p_21372_.getTicksFrozen() + freezeTick), (int)0, (int)600));
        }
        return flag;
    }

    public boolean isLeftHanded() {
        return false;
    }

    protected AABB getAttackBoundingBox() {
        return this.getMainHandItem().is((Item)FrostItems.FROST_SPEAR.get()) ? super.getAttackBoundingBox().inflate(1.5, 0.0, 1.5) : super.getAttackBoundingBox();
    }

    public static enum SeekerState implements StringRepresentable
    {
        IDLE("idle", 0, 0){

            public boolean shouldHideInShell(long p_326483_) {
                return false;
            }
        }
        ,
        PRE_ATTACK("pre_attack", -1, 1){}
        ,
        STOP_ATTACK("stop_attack", 3, 2){}
        ,
        ATTACK("attack", 80, 3){

            @Override
            public boolean canLook() {
                return false;
            }

            @Override
            public boolean canWalk() {
                return false;
            }
        }
        ,
        BREATH_PRE("breath_pre", 40, 4){

            @Override
            public boolean canLook() {
                return false;
            }

            @Override
            public boolean canWalk() {
                return false;
            }
        }
        ,
        BREATH("breath", -1, 5){

            @Override
            public boolean canLook() {
                return false;
            }

            @Override
            public boolean canWalk() {
                return false;
            }
        }
        ,
        BREATH_STOP("breath_stop", 10, 6){

            @Override
            public boolean canLook() {
                return false;
            }

            @Override
            public boolean canWalk() {
                return false;
            }
        };

        static final Codec<SeekerState> CODEC;
        private static final IntFunction<SeekerState> BY_ID;
        public static final StreamCodec<ByteBuf, SeekerState> STREAM_CODEC;
        private final String name;
        private final int animationDuration;
        private final int id;

        private SeekerState(String p_316309_, int p_320184_, int p_326087_) {
            this.name = p_316309_;
            this.animationDuration = p_320184_;
            this.id = p_326087_;
        }

        public String getSerializedName() {
            return this.name;
        }

        private int id() {
            return this.id;
        }

        public boolean isLoop() {
            return this.animationDuration < 0;
        }

        public int animationDuration() {
            return this.animationDuration;
        }

        public boolean canLook() {
            return true;
        }

        public boolean canWalk() {
            return true;
        }

        static {
            CODEC = StringRepresentable.fromEnum(SeekerState::values);
            BY_ID = ByIdMap.continuous(SeekerState::id, (Object[])SeekerState.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, SeekerState::id);
        }
    }
}

