/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class CounterGoal
extends Goal {
    protected final PathfinderMob attacker;
    protected boolean attack;
    protected boolean trigger;
    protected final int actionPoint;
    protected final int attackLengh;
    private int ticksUntilNextAttack;

    public CounterGoal(PathfinderMob attacker, int actionPoint, int attackLengh) {
        this.attacker = attacker;
        this.actionPoint = actionPoint;
        this.attackLengh = attackLengh;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void trigger() {
        this.trigger = true;
    }

    public boolean canUse() {
        return this.trigger;
    }

    public boolean canContinueToUse() {
        return this.ticksUntilNextAttack <= this.attackLengh;
    }

    public void start() {
        super.start();
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        super.stop();
        this.attack = false;
        this.attacker.setAggressive(false);
        this.trigger = false;
    }

    public void tick() {
        LivingEntity livingentity = this.attacker.getTarget();
        if (livingentity != null) {
            this.attacker.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            this.checkAndPerformAttack(livingentity);
            ++this.ticksUntilNextAttack;
        }
    }

    protected void checkAndPerformAttack(LivingEntity p_29589_) {
        if (this.ticksUntilNextAttack == this.actionPoint) {
            if (this.canPerformAttack(p_29589_)) {
                this.attacker.doHurtTarget(CounterGoal.getServerLevel((Entity)this.attacker), (Entity)p_29589_);
            }
        } else if (this.canPerformAttack(p_29589_) && this.ticksUntilNextAttack == 0) {
            this.doTheAnimation();
        }
    }

    protected boolean canPerformAttack(LivingEntity p_301160_) {
        return this.attacker.isWithinMeleeAttackRange(p_301160_) && this.attacker.getSensing().hasLineOfSight((Entity)p_301160_);
    }

    protected void doTheAnimation() {
        this.attacker.level().broadcastEntityEvent((Entity)this.attacker, (byte)61);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

