/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.entity.boss.Seeker;
import baguchan.frostrealm.registry.FrostDamageType;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeekerBreathGoal
extends Goal {
    private final Seeker mob;
    private int cooldown = 0;
    private int attackTime;

    public SeekerBreathGoal(Seeker rangedAttackMob) {
        this.mob = rangedAttackMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.mob.getTarget();
        if (this.mob.getState() == Seeker.SeekerState.PRE_ATTACK) {
            if (this.cooldown <= 0) {
                this.cooldown = 100 + this.mob.getRandom().nextInt(100);
                if (livingentity != null && livingentity.isAlive() && this.mob.getSensing().hasLineOfSight((Entity)livingentity)) {
                    this.mob.lookAt((Entity)livingentity, 3.0f, 3.0f);
                    return true;
                }
            } else {
                --this.cooldown;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.mob.getState() == Seeker.SeekerState.BREATH_PRE || this.mob.getState() == Seeker.SeekerState.BREATH;
    }

    public void start() {
        super.start();
        this.attackTime = 0;
        this.mob.setState(Seeker.SeekerState.BREATH_PRE);
        this.mob.playSound(SoundEvents.PLAYER_BREATH, 2.0f, 1.0f);
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.mob.getTarget();
        if (livingentity != null) {
            this.mob.lookAt((Entity)livingentity, 3.0f, 3.0f);
            if (this.mob.getState() == Seeker.SeekerState.BREATH) {
                this.doAttack();
            }
        }
        if (this.attackTime >= 160 && this.mob.getState() != Seeker.SeekerState.BREATH_STOP) {
            this.mob.setState(Seeker.SeekerState.BREATH_STOP);
        } else {
            ++this.attackTime;
        }
    }

    protected void doAttack() {
        Level var3 = this.mob.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var3;
            List entitiesHit = serverLevel.getEntitiesOfClass(LivingEntity.class, this.getAttackBoundingBox((PathfinderMob)this.mob));
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.mob || !this.mob.canAttack(entity) || this.mob.isAlliedTo((Entity)entity)) continue;
                Vec3 vec3 = entity.getEyePosition();
                Vec3 yVector = this.mob.calculateViewVector(this.mob.getXRot(), this.mob.getYHeadRot());
                Vec3 vec32 = vec3.subtract(this.mob.getEyePosition());
                Vec3 vec33 = new Vec3(vec32.x, vec32.y, vec32.z).normalize();
                double d0 = Math.acos(vec33.dot(yVector));
                if (!this.resolveAttack(d0, 60.0)) continue;
                entity.setTicksFrozen(entity.getTicksFrozen() + 3);
                entity.hurt(this.mob.damageSources().source(FrostDamageType.FREEZE_BREATH, (Entity)this.mob), 3.0f);
            }
        }
    }

    public AABB getAttackBoundingBox(PathfinderMob attacker) {
        AABB aabb;
        Entity entity = attacker.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = attacker.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = attacker.getBoundingBox();
        }
        return aabb.inflate(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f).inflate(12.0);
    }

    public boolean resolveAttack(double yRot, double yRotAttackRange) {
        return !(yRot > 0.01745329238474369 * yRotAttackRange);
    }
}

