/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchan.frostrealm.entity.Yeti;
import baguchan.frostrealm.entity.animal.SnowPileQuail;
import baguchan.frostrealm.entity.brain.YetiAi;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class StealFromYetiGoal
extends Goal {
    private final SnowPileQuail animal;
    private Yeti target;
    private final double speedModifier;
    private int cooldown;

    public StealFromYetiGoal(SnowPileQuail p_25319_, double p_25320_) {
        this.animal = p_25319_;
        this.speedModifier = p_25320_;
    }

    public boolean canUse() {
        if (this.animal.isBaby() || this.animal.getStealTarget() != null || !this.animal.getMainHandItem().isEmpty() || this.animal.hasEgg() || this.cooldown > 0) {
            return false;
        }
        List list = this.animal.level().getEntitiesOfClass(Yeti.class, this.animal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Yeti animal = null;
        double d0 = Double.MAX_VALUE;
        for (Yeti animal1 : list) {
            double d1;
            if (animal1.isBaby() || (d1 = this.animal.distanceToSqr((Entity)animal1)) > d0) continue;
            d0 = d1;
            animal = animal1;
        }
        if (animal == null) {
            return false;
        }
        if (d0 < 9.0) {
            return false;
        }
        if (animal.hasFood().isEmpty()) {
            return false;
        }
        this.cooldown = 600 + this.animal.getRandom().nextIntBetweenInclusive(300, 600);
        this.target = animal;
        return true;
    }

    public boolean canContinueToUse() {
        if (!this.animal.isBaby()) {
            return false;
        }
        if (!this.target.isAlive()) {
            return false;
        }
        double d0 = this.animal.distanceToSqr((Entity)this.target);
        return !(d0 < 12.0) && !(d0 > 256.0);
    }

    public void start() {
    }

    public void stop() {
        double d0 = this.animal.distanceToSqr((Entity)this.target);
        if (d0 < 14.0) {
            YetiAi.stealFromYeti((LivingEntity)this.animal, this.target);
        }
        this.animal.setStealTarget((LivingEntity)this.target);
    }

    public void tick() {
        this.animal.getNavigation().moveTo((Entity)this.target, this.speedModifier);
    }
}

