/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.goal;

import baguchi.bagus_lib.entity.goal.AnimateAttackGoal;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WideMeleeAttackGoal
extends AnimateAttackGoal {
    protected final double range;

    public WideMeleeAttackGoal(PathfinderMob attacker, double speed, int actionPoint, int attackLength, double range) {
        super(attacker, speed, actionPoint, attackLength);
        this.range = range;
    }

    protected void doAttack(LivingEntity living) {
        Level var3 = this.mob.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var3;
            List entitiesHit = serverLevel.getEntitiesOfClass(LivingEntity.class, this.getAttackBoundingBox(this.mob));
            for (LivingEntity entity : entitiesHit) {
                if (entity == this.mob || !this.mob.canAttack(entity) || this.mob.isAlliedTo((Entity)entity)) continue;
                Vec3 vec3 = entity.getEyePosition();
                Vec3 yVector = this.mob.calculateViewVector(this.mob.getXRot(), this.mob.getYHeadRot());
                Vec3 vec32 = vec3.subtract(this.mob.getEyePosition());
                Vec3 vec33 = new Vec3(vec32.x, vec32.y, vec32.z).normalize();
                double d0 = Math.acos(vec33.dot(yVector));
                if (!this.resolveAttack(d0, this.range)) continue;
                this.mob.doHurtTarget(serverLevel, (Entity)entity);
            }
        }
    }

    public AABB getAttackBoundingBox(PathfinderMob attacker) {
        AABB aabb;
        Entity entity = attacker.getVehicle();
        if (entity != null) {
            AABB aabb1 = entity.getBoundingBox();
            AABB aabb2 = attacker.getBoundingBox();
            aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
        } else {
            aabb = attacker.getBoundingBox();
        }
        return aabb.inflate(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
    }

    public boolean resolveAttack(double yRot, double yRotAttackRange) {
        return !(yRot > 0.01745329238474369 * yRotAttackRange);
    }
}

