/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.entity.goal.RollGoal;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostTags;
import baguchan.frostrealm.utils.CombatUtils;
import baguchi.bagus_lib.client.camera.CameraCore;
import baguchi.bagus_lib.client.camera.holder.CameraHolder;
import baguchi.bagus_lib.util.GlobalVec3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Gokkur
extends Monster {
    protected static final EntityDataAccessor<Boolean> GRASS = SynchedEntityData.defineId(Gokkur.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Float> SNOW_PROGRESS = SynchedEntityData.defineId(Gokkur.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final ProjectileDeflection PROJECTILE_DEFLECTION = (p_344345_, p_344346_, p_344347_) -> {
        p_344346_.level().playSound((Entity)((Player)null), p_344346_, SoundEvents.ANVIL_PLACE, p_344346_.getSoundSource(), 1.0f, 1.5f);
        ProjectileDeflection.REVERSE.deflect(p_344345_, p_344346_, p_344347_);
    };
    private static final EntityDimensions SPIN_DIMENSIONS = EntityDimensions.scalable((float)1.0f, (float)1.0f).withEyeHeight(0.5f);
    public AnimationState rollAnimationState = new AnimationState();
    public AnimationState startRollAnimationState = new AnimationState();

    public Gokkur(EntityType<? extends Gokkur> entityType, Level level) {
        super(entityType, level);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.getNavigation();
        groundpathnavigation.setCanFloat(false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_312373_) {
        if (this.level().isClientSide() && DATA_POSE.equals(p_312373_)) {
            this.stopAllAnimation();
            Pose pose = this.getPose();
            switch (pose) {
                case SITTING: {
                    this.startRollAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case SPIN_ATTACK: {
                    this.rollAnimationState.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_312373_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GRASS, (Object)false);
        builder.define(SNOW_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void setGrass(boolean grass) {
        this.entityData.set(GRASS, (Object)grass);
    }

    public boolean isGrass() {
        return (Boolean)this.entityData.get(GRASS);
    }

    public void setSnowProgress(float progress) {
        this.entityData.set(SNOW_PROGRESS, (Object)Float.valueOf(progress));
    }

    public float getSnowProgress() {
        return ((Float)this.entityData.get(SNOW_PROGRESS)).floatValue();
    }

    private void stopAllAnimation() {
        this.rollAnimationState.stop();
        this.startRollAnimationState.stop();
    }

    public EntityDimensions getDefaultDimensions(Pose p_316664_) {
        return p_316664_ == Pose.SPIN_ATTACK ? SPIN_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(p_316664_);
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Grass", this.isGrass());
        tag.putFloat("SnowProgress", this.getSnowProgress());
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.setGrass(tag.getBooleanOr("Grass", false));
        this.setSnowProgress(tag.getFloatOr("SnowProgress", 0.0f));
    }

    public void tick() {
        super.tick();
        if (this.getPose() == Pose.SPIN_ATTACK) {
            if (this.level().getBlockState(this.getOnPos()).is(BlockTags.SNOW) && this.getSnowProgress() <= 1.5f) {
                this.setSnowProgress(this.getSnowProgress() + 0.05f);
            }
            if (this.level().getBlockState(this.blockPosition()).is(BlockTags.SNOW) && this.getSnowProgress() <= 1.5f) {
                this.setSnowProgress(this.getSnowProgress() + 0.05f);
            }
        }
    }

    public boolean canSpawnSprintParticle() {
        return super.canSpawnSprintParticle() || this.getPose() == Pose.SPIN_ATTACK;
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
        super.playStepSound(p_20135_, p_20136_);
        this.playSound(SoundEvents.STONE_STEP, 0.8f, this.getVoicePitch());
    }

    protected float nextStep() {
        if (this.getPose() == Pose.SPIN_ATTACK) {
            return this.moveDist + 0.25f;
        }
        return super.nextStep();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RollGoal((Mob)this, 20, 30));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)0.8f, false));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ARMOR, 8.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    protected void dealDamage(LivingEntity livingentity) {
        Level level;
        if (this.isAlive() && this.getPose() == Pose.SPIN_ATTACK && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean flag = CombatUtils.isBlockingWithOutCheck(serverLevel, livingentity, this.damageSources().mobAttack((LivingEntity)this), this.getAttackDamage() * 1.5f + this.getSnowProgress()) >= this.getAttackDamage() * 1.5f + this.getSnowProgress();
            float f1 = (float)Mth.clamp((double)(livingentity.getDeltaMovement().horizontalDistanceSqr() * 1.5), (double)0.5, (double)3.0);
            float f2 = flag ? 0.25f + this.getSnowProgress() * 0.25f : 1.0f + this.getSnowProgress() * 0.5f;
            double d1 = this.getX() - livingentity.getX();
            double d2 = this.getZ() - livingentity.getZ();
            double d3 = livingentity.getX() - this.getX();
            double d4 = livingentity.getZ() - this.getZ();
            if (livingentity.hurtServer(serverLevel, this.damageSources().mobAttack((LivingEntity)this), (float)Mth.floor((float)(this.getAttackDamage() * 1.5f + this.getSnowProgress())))) {
                this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                livingentity.knockback((double)(f2 * f1), d1, d2);
            }
        }
    }

    public void push(Entity p_33636_) {
        if (p_33636_ instanceof LivingEntity && !(p_33636_ instanceof Gokkur)) {
            this.dealDamage((LivingEntity)p_33636_);
        }
        super.push(p_33636_);
    }

    public boolean hurtServer(ServerLevel p_376221_, DamageSource p_376460_, float p_376610_) {
        ItemStack itemstack = p_376460_.getWeaponItem();
        float damageScale = 1.0f;
        if (p_376460_.getWeaponItem() != null && p_376460_.getWeaponItem().has(DataComponents.TOOL)) {
            if (((Tool)p_376460_.getWeaponItem().get(DataComponents.TOOL)).isCorrectForDrops(((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState())) {
                damageScale = 2.0f;
            }
        } else if (p_376460_.is(DamageTypeTags.IS_PROJECTILE)) {
            damageScale = 0.25f;
        }
        Crackiness.Level crackiness$level = this.getCrackiness();
        boolean flag = super.hurtServer(p_376221_, p_376460_, p_376610_ * damageScale);
        if (flag && this.getCrackiness() != crackiness$level) {
            this.playSound(SoundEvents.STONE_BREAK, 1.0f, 1.0f);
            p_376221_.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getEntityBlocks()), this.getRandomX(this.getBbWidth() / 2.0f), this.getRandomY(), this.getRandomZ(this.getBbWidth() / 2.0f), 10, (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)0.15f);
            if (this.getSnowProgress() > 0.25f) {
                this.setSnowProgress(this.getSnowProgress() - 0.25f);
                p_376221_.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), this.getRandomX(this.getBbWidth() / 2.0f), this.getRandomY(), this.getRandomZ(this.getBbWidth() / 2.0f), 10, (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)0.15f);
            } else if (this.getSnowProgress() > 0.0f) {
                this.setSnowProgress(0.0f);
                p_376221_.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW_BLOCK.defaultBlockState()), this.getRandomX(this.getBbWidth() / 2.0f), this.getRandomY(), this.getRandomZ(this.getBbWidth() / 2.0f), 5, (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)((float)this.random.nextIntBetweenInclusive(-2, 2) * 0.15f), (double)0.15f);
            }
        }
        return flag;
    }

    public BlockState getEntityBlocks() {
        return ((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState();
    }

    public ProjectileDeflection deflection(Projectile p_319824_) {
        return this.hasPose(Pose.SPIN_ATTACK) ? PROJECTILE_DEFLECTION : super.deflection(p_319824_);
    }

    protected float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    protected void blockedByItem(LivingEntity p_21246_) {
        super.blockedByItem(p_21246_);
        if (this.isAlive() && this.getPose() == Pose.SPIN_ATTACK) {
            this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.knockback(0.8f, p_21246_.getX() - this.getX(), p_21246_.getZ() - this.getZ());
            this.setPose(Pose.STANDING);
            CameraCore.addCameraHolderList((Level)this.level(), (CameraHolder)new CameraHolder(8, 30, 0.085f, GlobalVec3.of((ResourceKey)this.level().dimension(), (Vec3)this.position())));
        }
    }

    protected int decreaseAirSupply(int p_28882_) {
        return p_28882_;
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != MobEffects.POISON && super.canBeAffected(effect);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_21435_, EntitySpawnReason p_21436_, @Nullable SpawnGroupData p_21437_) {
        if (serverLevelAccessor.getBiome(this.blockPosition()).is(FrostTags.Biomes.GRASS_FROST_BIOME)) {
            this.setGrass(true);
        }
        return super.finalizeSpawn(serverLevelAccessor, p_21435_, p_21436_, p_21437_);
    }
}

