/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.hostile;

import baguchan.frostrealm.entity.goal.AppearGoal;
import baguchan.frostrealm.entity.goal.NonMoveAnimateAttackGoal;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostEntities;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RootDeer
extends Monster {
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID = SynchedEntityData.defineId(RootDeer.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private final int attackAnimationLength = 30;
    private final int attackAnimationActionPoint = 10;
    private int attackAnimationTick;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState summonAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public static final Predicate<LivingEntity> FROST_PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.getType();
        return entitytype != FrostEntities.CRYSTAL_FOX.get();
    };

    public RootDeer(EntityType<? extends RootDeer> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.setAttachFace(Direction.DOWN);
        this.xpReward = 4;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_219067_) {
        super.recreateFromPacket(p_219067_);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new AppearGoal((PathfinderMob)this, 20));
        this.goalSelector.addGoal(1, (Goal)new NonMoveAnimateAttackGoal((PathfinderMob)this, 10, 30){

            public boolean canUse() {
                return RootDeer.this.getPose() != Pose.EMERGING && super.canUse();
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true, (living, serverlevel) -> FROST_PREY_SELECTOR.test(living)));
    }

    protected BodyRotationControl createBodyControl() {
        return new VineBodyRotationControl((Mob)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ARMOR, 4.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    public static boolean checkDeerSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, EntitySpawnReason p_361180_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219015_.getDifficulty() != Difficulty.PEACEFUL && (EntitySpawnReason.ignoresLightRequirements((EntitySpawnReason)p_361180_) || RootDeer.isDarkEnoughToSpawn((ServerLevelAccessor)p_219015_, (BlockPos)p_219017_, (RandomSource)p_219018_)) && RootDeer.checkDirectionSpawnRules((LevelAccessor)p_219015_, p_219017_);
    }

    public boolean checkSpawnRules(LevelAccessor p_21686_, EntitySpawnReason p_361803_) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader p_21433_) {
        return !p_21433_.containsAnyLiquid(this.getBoundingBox()) && p_21433_.getBlockState(this.blockPosition()).isAir();
    }

    public static boolean checkDirectionSpawnRules(LevelAccessor p_217059_, BlockPos p_217061_) {
        int n = 0;
        Direction[] directionArray = Direction.values();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            BlockPos blockpos = p_217061_.offset(direction.getUnitVec3i());
            return p_217059_.getBlockState(blockpos).is(FrostBlocks.FROSTBITE_LOG);
        }
        return false;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_149780_, DifficultyInstance p_149781_, EntitySpawnReason p_363202_, @Nullable SpawnGroupData p_149783_) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        this.setPose(Pose.EMERGING);
        return super.finalizeSpawn(p_149780_, p_149781_, p_363202_, p_149783_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ATTACH_FACE_ID, (Object)Direction.DOWN);
    }

    public void readAdditionalSaveData(ValueInput p_33432_) {
        super.readAdditionalSaveData(p_33432_);
        this.setAttachFace(Direction.from3DDataValue((int)p_33432_.getByteOr("AttachFace", (byte)0)));
    }

    public void addAdditionalSaveData(ValueOutput p_33443_) {
        super.addAdditionalSaveData(p_33443_);
        p_33443_.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
    }

    public void setPos(double p_33449_, double p_33450_, double p_33451_) {
        BlockPos blockpos = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(p_33449_, p_33450_, p_33451_);
        } else {
            super.setPos((double)Mth.floor((double)p_33449_) + 0.5, (double)Mth.floor((double)(p_33450_ + 0.5)), (double)Mth.floor((double)p_33451_) + 0.5);
        }
    }

    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    public void setDeltaMovement(Vec3 p_149804_) {
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    private void findNewAttachment() {
        Direction direction = this.findAttachableSurface(this.blockPosition());
        if (direction != null && this.tickCount < 5) {
            this.setAttachFace(direction);
        } else {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.kill(serverLevel);
            }
        }
    }

    @Nullable
    protected Direction findAttachableSurface(BlockPos p_149811_) {
        for (Direction direction : Direction.values()) {
            if (!this.canStayAt(p_149811_, direction)) continue;
            return direction;
        }
        return null;
    }

    boolean canStayAt(BlockPos p_149786_, Direction p_149787_) {
        if (this.isPositionBlocked(p_149786_)) {
            return false;
        }
        Direction direction = p_149787_.getOpposite();
        return this.level().loadedAndEntityCanStandOnFace(p_149786_.relative(p_149787_), (Entity)this, direction.getOpposite());
    }

    private boolean isPositionBlocked(BlockPos p_149813_) {
        BlockState blockstate = this.level().getBlockState(p_149813_);
        if (blockstate.isAir()) {
            return false;
        }
        boolean flag = blockstate.is(Blocks.MOVING_PISTON) && p_149813_.equals((Object)this.blockPosition());
        return !flag;
    }

    public Direction getAttachFace() {
        return (Direction)this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    public void setAttachFace(Direction p_149789_) {
        this.entityData.set(DATA_ATTACH_FACE_ID, (Object)p_149789_);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_219422_) {
        if (DATA_POSE.equals(p_219422_)) {
            switch (this.getPose()) {
                case EMERGING: {
                    this.summonAnimationState.start(this.tickCount);
                }
            }
        }
        if (DATA_ATTACH_FACE_ID.equals(p_219422_)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(p_219422_);
    }

    protected AABB makeBoundingBox(Vec3 p_388602_) {
        Direction direction = this.getAttachFace().getOpposite();
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        double d6 = (double)this.getType().getWidth() / 2.0;
        double d7 = (double)this.getType().getHeight() / 2.0;
        double d8 = (double)this.getType().getWidth() / 2.0;
        if (direction.getAxis() == Direction.Axis.Z) {
            d8 = this.getType().getHeight() / 2.0f;
            d7 = this.getType().getWidth() / 2.0f;
            d1 += (double)this.getType().getWidth();
        } else if (direction.getAxis() == Direction.Axis.X) {
            d6 = this.getType().getHeight() / 2.0f;
            d7 = this.getType().getWidth() / 2.0f;
            d1 += (double)this.getType().getWidth();
        } else if (direction == Direction.UP) {
            d7 = (double)this.getType().getHeight() / 2.0;
            d1 += (double)this.getType().getHeight() / 2.0;
        }
        return new AABB(d0 - d6, d1 - d7, d2 - d8, d0 + d6, d1 + d7, d2 + d8);
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.stop();
            }
        }
    }

    public void tick() {
        super.tick();
        if (!(this.level().isClientSide() || this.isPassenger() || this.canStayAt(this.blockPosition(), this.getAttachFace()))) {
            this.findNewAttachment();
        }
        switch (this.getPose()) {
            case EMERGING: {
                this.clientDiggingParticles();
                break;
            }
            case DIGGING: {
                this.clientDiggingParticles();
            }
        }
    }

    private void clientDiggingParticles() {
        BlockState blockstate = this.level().getBlockState(this.blockPosition().offset(this.getAttachFace().getUnitVec3i()));
        RandomSource randomsource = this.getRandom();
        float size = this.getDimensions(this.getPose()).width() / 2.0f;
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            SoundType soundType = blockstate.getSoundType();
            if (this.level().isClientSide()) {
                for (int i = 0; i < 4; ++i) {
                    Direction direction = this.getAttachFace();
                    double d0 = this.getX() + (double)Mth.randomBetween((RandomSource)randomsource, (float)(-size), (float)size) + (double)direction.getStepX();
                    double d1 = this.getY() + (double)direction.getStepY();
                    double d2 = this.getZ() + (double)Mth.randomBetween((RandomSource)randomsource, (float)(-size), (float)size) + (double)direction.getStepZ();
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            } else {
                this.playSound(soundType.getBreakSound());
            }
        }
    }

    protected void tickDeath() {
        if (this.level().isClientSide() && this.deathTime == 0) {
            this.deathAnimationState.start(this.tickCount);
            this.attackAnimationState.stop();
        }
        if (++this.deathTime >= 30 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                AABB aabb = this.getBoundingBox();
                Vec3 vec3 = aabb.getCenter();
                double d0 = aabb.getXsize() / 3.0;
                double d1 = aabb.getYsize();
                double d2 = aabb.getZsize() / 3.0;
                serverlevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, ((RotatedPillarBlock)FrostBlocks.FROSTBITE_LOG.get()).defaultBlockState()), vec3.x, vec3.y, vec3.z, 40, d0, d1, d2, 0.0);
                this.playSound(SoundType.CHERRY_WOOD.getBreakSound());
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationTick = 0;
            this.attackAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    public boolean hurtServer(ServerLevel p_376595_, DamageSource p_376181_, float p_376898_) {
        float damageScale = 1.0f;
        if (p_376181_.getWeaponItem() != null && p_376181_.getWeaponItem().has(DataComponents.TOOL) && ((Tool)p_376181_.getWeaponItem().get(DataComponents.TOOL)).isCorrectForDrops(((RotatedPillarBlock)FrostBlocks.FROSTBITE_LOG.get()).defaultBlockState())) {
            damageScale = 2.0f;
        }
        if (!this.isNoAi() && !this.isDiggingOrEmerging()) {
            boolean flag = super.hurtServer(p_376595_, p_376181_, p_376898_ * damageScale);
            return flag;
        }
        return false;
    }

    public boolean isDiggingOrEmerging() {
        return this.hasPose(Pose.DIGGING) || this.hasPose(Pose.EMERGING);
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().deflate((double)0.1f, 0.0, (double)0.1f).inflate(0.0, (double)0.1f, 0.0);
    }

    static class VineBodyRotationControl
    extends BodyRotationControl {
        public VineBodyRotationControl(Mob p_149816_) {
            super(p_149816_);
        }

        public void clientTick() {
        }
    }
}

