/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.path;

import baguchan.frostrealm.entity.path.node.LavaSwimNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class LavaPathNavigation
extends PathNavigation {
    public LavaPathNavigation(Mob p_26594_, Level p_26595_) {
        super(p_26594_, p_26595_);
    }

    protected PathFinder createPathFinder(int p_26598_) {
        this.nodeEvaluator = new LavaSwimNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.nodeEvaluator.setCanOpenDoors(false);
        this.nodeEvaluator.setCanFloat(true);
        return new PathFinder(this.nodeEvaluator, p_26598_);
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.mob.getY(0.5), this.mob.getZ());
    }

    protected double getGroundY(Vec3 p_186132_) {
        BlockPos blockpos = BlockPos.containing((Position)p_186132_);
        return this.level.getBlockState(blockpos.below()).isAir() || this.level.getBlockState(blockpos).getFluidState().is(FluidTags.LAVA) ? p_186132_.y : WalkNodeEvaluator.getFloorLevel((BlockGetter)this.level, (BlockPos)blockpos);
    }

    protected boolean canMoveDirectly(Vec3 p_186138_, Vec3 p_186139_) {
        return this.mob.isInLava() ? LavaPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)p_186138_, (Vec3)p_186139_, (boolean)false) : false;
    }

    public boolean isStableDestination(BlockPos p_26608_) {
        return !this.level.getBlockState(p_26608_.below()).isAir() || this.level.getBlockState(p_26608_).getFluidState().is(FluidTags.LAVA);
    }

    public void setCanFloat(boolean p_26563_) {
        this.nodeEvaluator.setCanFloat(p_26563_);
    }

    public boolean canNavigateGround() {
        return true;
    }
}

