/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.path.node;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class LavaSwimNodeEvaluator
extends WalkNodeEvaluator {
    public void prepare(PathNavigationRegion p_164671_, Mob p_164672_) {
        super.prepare(p_164671_, p_164672_);
        p_164672_.setPathfindingMalus(PathType.LAVA, 0.0f);
    }

    public void done() {
        super.done();
    }

    @Nullable
    public Node getStart() {
        return this.getStartNode(new BlockPos(Mth.floor((double)this.mob.getBoundingBox().minX), Mth.floor((double)(this.mob.getBoundingBox().minY + 0.5)), Mth.floor((double)this.mob.getBoundingBox().minZ)));
    }

    public Target getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(Mth.floor((double)x), Mth.floor((double)(y + 0.5)), Mth.floor((double)z));
    }

    public int getNeighbors(Node[] p_164676_, Node p_164677_) {
        int i = super.getNeighbors(p_164676_, p_164677_);
        PathType blockpathtypes = this.getCachedPathType(p_164677_.x, p_164677_.y + 1, p_164677_.z);
        PathType blockpathtypes1 = this.getCachedPathType(p_164677_.x, p_164677_.y, p_164677_.z);
        int j = this.mob.getPathfindingMalus(blockpathtypes) >= 0.0f && blockpathtypes1 != PathType.STICKY_HONEY ? Mth.floor((float)Math.max(1.0f, this.mob.maxUpStep())) : 0;
        double d0 = this.getFloorLevel(new BlockPos(p_164677_.x, p_164677_.y, p_164677_.z));
        Node node = this.findAcceptedNode(p_164677_.x, p_164677_.y + 1, p_164677_.z, Math.max(0, j - 1), d0, Direction.UP, blockpathtypes1);
        Node node1 = this.findAcceptedNode(p_164677_.x, p_164677_.y - 1, p_164677_.z, j, d0, Direction.DOWN, blockpathtypes1);
        if (this.isVerticalNeighborValid(node, p_164677_)) {
            p_164676_[i++] = node;
        }
        if (this.isVerticalNeighborValid(node1, p_164677_) && blockpathtypes1 != PathType.TRAPDOOR) {
            p_164676_[i++] = node1;
        }
        return i;
    }

    private boolean isVerticalNeighborValid(@Nullable Node p_230611_, Node p_230612_) {
        return this.isNeighborValid(p_230611_, p_230612_);
    }

    protected double getFloorLevel(BlockPos p_164674_) {
        return this.mob.isInLava() ? (double)p_164674_.getY() + 0.5 : super.getFloorLevel(p_164674_);
    }

    protected boolean isAmphibious() {
        return false;
    }

    public PathType getPathType(PathfindingContext p_164666_, int p_164667_, int p_164668_, int p_164669_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        PathType blockpathtypes = LavaSwimNodeEvaluator.getPathTypeStatic((PathfindingContext)p_164666_, (BlockPos.MutableBlockPos)blockpos$mutableblockpos.set(p_164667_, p_164668_, p_164669_));
        if (blockpathtypes == PathType.LAVA) {
            for (Direction direction : Direction.values()) {
                PathType blockpathtypes1 = LavaSwimNodeEvaluator.getPathTypeStatic((PathfindingContext)p_164666_, (BlockPos.MutableBlockPos)blockpos$mutableblockpos.set(p_164667_, p_164668_, p_164669_).move(direction));
                if (blockpathtypes1 != PathType.BLOCKED) continue;
                return PathType.BLOCKED;
            }
            return PathType.LAVA;
        }
        return super.getPathType(p_164666_, p_164667_, p_164668_, p_164669_);
    }
}

