/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.projectile;

import baguchan.frostrealm.entity.hostile.Gokkur;
import baguchan.frostrealm.registry.FrostEntities;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class FlyingBlockEntity
extends ThrowableProjectile {
    public static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(FlyingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private boolean canPlace = false;
    private boolean isFromVolcano = false;

    public FlyingBlockEntity(EntityType<? extends FlyingBlockEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public FlyingBlockEntity(Level world, LivingEntity thrower, @Nullable BlockState state) {
        super((EntityType)FrostEntities.FLYING_BLOCK.get(), thrower.getX(), thrower.getY(), thrower.getZ(), world);
        this.setOwner((Entity)thrower);
        if (state != null) {
            this.setBlockState(state);
        }
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        tag.store("BlockState", BlockState.CODEC, (Object)this.getBlockState());
        tag.putBoolean("Volcano", this.isFromVolcano);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326113_) {
        p_326113_.define(STATE, (Object)Blocks.SNOW_BLOCK.defaultBlockState());
    }

    public void setBlockState(BlockState p_307211_) {
        this.entityData.set(STATE, (Object)p_307211_);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(STATE);
    }

    public void setFromVolcano(boolean fromVolcano) {
        this.isFromVolcano = fromVolcano;
    }

    public boolean isFromVolcano() {
        return this.isFromVolcano;
    }

    protected void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.setBlockState(tag.read("BlockState", BlockState.CODEC).orElse(Blocks.SNOW_BLOCK.defaultBlockState()));
        this.setFromVolcano(tag.getBooleanOr("Volcano", false));
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockState());
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.05);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public DamageSource blockAttack(@Nullable Entity p_270857_) {
        return this.damageSources().source(DamageTypes.FALLING_BLOCK, (Entity)this, p_270857_);
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity living;
        Entity entity;
        super.onHitEntity(result);
        if (!(this.level().isClientSide() || this.getOwner() == result.getEntity() || (entity = this.getOwner()) instanceof LivingEntity && (living = (LivingEntity)entity).isAlliedTo(result.getEntity()))) {
            result.getEntity().hurt(this.blockAttack(this.getOwner()), 3.0f);
            this.playSound(this.getBlockState().getSoundType().getBreakSound());
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.generateMagmaEntity();
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide() && !this.isPassenger()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.gameEvent((Holder)GameEvent.BLOCK_DESTROY, this.getOwner());
            this.playSound(this.getBlockState().getSoundType().getBreakSound());
            if (this.canPlace) {
                this.level().setBlock(this.blockPosition(), this.getBlockState(), 2);
            }
            this.generateMagmaEntity();
            this.discard();
        }
    }

    protected void generateMagmaEntity() {
        if (this.isFromVolcano && this.random.nextFloat() < 0.005f) {
            Gokkur flyingBlockEntity = (Gokkur)((EntityType)FrostEntities.GOKKUR.get()).create(this.level(), EntitySpawnReason.EVENT);
            flyingBlockEntity.snapTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            this.level().addFreshEntity((Entity)flyingBlockEntity);
        }
    }

    public void setCanPlace(boolean canPlace) {
        this.canPlace = canPlace;
    }
}

