/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.entity.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class GuardHandler {
    protected final int hurtTriggerCount;
    protected int hurtCount;
    protected int hurtTick;
    protected boolean trigger;

    public GuardHandler(int hurtTriggerCount) {
        this.hurtTriggerCount = hurtTriggerCount;
    }

    public void tick(Mob entity) {
        if (!entity.level().isClientSide()) {
            if (this.hurtCount > this.hurtTriggerCount) {
                this.trigger = true;
            }
            if (this.hurtTick > 0) {
                --this.hurtTick;
            } else {
                this.resetTrigger(true);
            }
        }
    }

    public void addHurtCount(float damage) {
        ++this.hurtCount;
        this.hurtTick = (int)Mth.clamp((float)(damage * 10.0f + (float)this.hurtTick), (float)0.0f, (float)600.0f);
    }

    public boolean isTrigger() {
        return this.trigger;
    }

    public void setTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public void resetTrigger(boolean trigger) {
        this.hurtCount = 0;
        this.trigger = false;
    }
}

