/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.item;

import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.world.FrostPortalShape;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.PortalShape;

public class FrostCatalystItem
extends Item {
    public FrostCatalystItem(Item.Properties tab) {
        super(tab);
    }

    public InteractionResult useOn(UseOnContext context) {
        Optional<FrostPortalShape> optional;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (FrostCatalystItem.inPortalDimension(level) && (optional = FrostPortalShape.findEmptyPortalShape((LevelAccessor)level, pos.offset(context.getClickedFace().getUnitVec3i()), Direction.Axis.X)).isPresent()) {
            optional.get().createPortalBlocks();
            if (!player.isCreative()) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getHand());
            }
            level.playSound((Entity)player, pos, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.BLOCKS, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private static boolean inPortalDimension(Level p_49249_) {
        return p_49249_.dimension() == Level.OVERWORLD || p_49249_.dimension() == FrostDimensions.FROSTREALM_LEVEL;
    }

    private static boolean isPortal(Level p_49270_, BlockPos p_49271_, Direction p_49272_) {
        if (!FrostCatalystItem.inPortalDimension(p_49270_)) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_49271_.mutable();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!p_49270_.getBlockState((BlockPos)blockpos$mutableblockpos.set((Vec3i)p_49271_).move(direction)).isPortalFrame((BlockGetter)p_49270_, (BlockPos)blockpos$mutableblockpos)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis direction$axis = p_49272_.getAxis().isHorizontal() ? p_49272_.getCounterClockWise().getAxis() : Direction.Plane.HORIZONTAL.getRandomAxis(p_49270_.random);
        return PortalShape.findEmptyPortalShape((LevelAccessor)p_49270_, (BlockPos)p_49271_, (Direction.Axis)direction$axis).isPresent();
    }

    public boolean isFoil(ItemStack p_77636_1_) {
        return true;
    }
}

