/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.item;

import baguchan.frostrealm.capability.FrostLivingCapability;
import baguchan.frostrealm.client.FrostArmPoses;
import baguchan.frostrealm.registry.FrostAttachs;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class GlimmerRockItem
extends Item {
    public GlimmerRockItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack p_151209_, Level p_151210_, LivingEntity p_151211_) {
        if (p_151211_ instanceof Player) {
            Player player = (Player)p_151211_;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        FrostLivingCapability cap = (FrostLivingCapability)p_151211_.getData(FrostAttachs.FROST_LIVING.get());
        cap.setTemperatureLevel(cap.getTemperatureLevel() + 1);
        cap.setSaturation(cap.getSaturationLevel() + 0.05f);
        p_151211_.setTicksFrozen(0);
        p_151209_.shrink(1);
        return p_151209_;
    }

    public void onUseTick(Level p_41428_, LivingEntity livingEntity, ItemStack p_41430_, int count) {
        super.onUseTick(p_41428_, livingEntity, p_41430_, count);
        if (count % 6 == 0) {
            livingEntity.playSound(SoundEvents.REDSTONE_TORCH_BURNOUT, 0.3f, 1.0f);
        }
    }

    public InteractionResult use(Level p_42927_, Player p_42928_, InteractionHand p_42929_) {
        return ItemUtils.startUsingInstantly((Level)p_42927_, (Player)p_42928_, (InteractionHand)p_42929_);
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 40;
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.DRINK;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, TooltipDisplay p_399753_, Consumer<Component> p_399884_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_399753_, p_399884_, p_41424_);
        p_399884_.accept(CommonComponents.EMPTY);
        p_399884_.accept((Component)Component.translatable((String)"item.frostrealm.glimmerrock.tooltip"));
    }

    public static final class ItemRender
    implements IClientItemExtensions {
        private static final ItemRender INSTANCE = new ItemRender();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            return (HumanoidModel.ArmPose)FrostArmPoses.RUB_HAND.getValue();
        }

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            if (player.isUsingItem()) {
                this.applyEatTransform(poseStack, player, partialTick, arm, itemInHand);
            }
            this.applyItemArmTransform(poseStack, arm, equipProcess);
            this.applyItemArmAttackTransform(poseStack, arm, swingProcess);
            return true;
        }

        private void applyItemArmAttackTransform(PoseStack p_109336_, HumanoidArm p_109337_, float p_109338_) {
            int i = p_109337_ == HumanoidArm.RIGHT ? 1 : -1;
            float f = Mth.sin((float)(p_109338_ * p_109338_ * (float)Math.PI));
            p_109336_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * (45.0f + f * -20.0f)));
            float f1 = Mth.sin((float)(Mth.sqrt((float)p_109338_) * (float)Math.PI));
            p_109336_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)i * f1 * -20.0f));
            p_109336_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * -80.0f));
            p_109336_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * -45.0f));
        }

        private void applyEatTransform(PoseStack p_109331_, LocalPlayer player, float p_109332_, HumanoidArm p_109333_, ItemStack p_109334_) {
            float f = (float)player.getUseItemRemainingTicks() - p_109332_ + 1.0f;
            float f1 = f / (float)p_109334_.getUseDuration((LivingEntity)player);
            if (f1 < 0.8f) {
                float f2 = Mth.abs((float)(Mth.cos((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
                p_109331_.translate(0.0f, f2, 0.0f);
            }
            float f3 = 1.0f - (float)Math.pow(f1, 20.0);
            int i = p_109333_ == HumanoidArm.RIGHT ? 1 : -1;
            p_109331_.translate(f3 * 0.6f * (float)i, f3 * -0.5f, f3 * 0.0f);
            p_109331_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * f3 * 90.0f));
            p_109331_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f3 * 10.0f));
            p_109331_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)i * f3 * 30.0f));
        }

        private void applyItemArmTransform(PoseStack p_109383_, HumanoidArm p_109384_, float p_109385_) {
            int i = p_109384_ == HumanoidArm.RIGHT ? 1 : -1;
            p_109383_.translate((float)i * 0.56f, -0.52f + p_109385_ * -0.6f, -0.72f);
        }
    }
}

