/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.item;

import baguchan.frostrealm.api.IItemAnimation;
import baguchan.frostrealm.capability.FrostLivingCapability;
import baguchan.frostrealm.registry.FrostAnimations;
import baguchan.frostrealm.registry.FrostAttachs;
import baguchi.bagus_lib.util.client.BagusAnimationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;

public class SpearItem
extends Item
implements IItemAnimation {
    public static final ResourceLocation BASE_ENTITY_RANGE = ResourceLocation.withDefaultNamespace((String)"base_entity_range");
    public static final ResourceLocation BASE_BLOCK_RANGE = ResourceLocation.withDefaultNamespace((String)"base_block_range");

    public SpearItem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && !entity.swinging) {
            FrostLivingCapability capability = (FrostLivingCapability)player.getData(FrostAttachs.FROST_LIVING);
            BagusAnimationUtil.sendAnimation((Entity)player, (ResourceLocation)FrostAnimations.SPEAR_ATTACK);
            capability.usingItem = player.getItemBySlot(EquipmentSlot.MAINHAND).copy();
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    @Override
    public void onEntityStopAnimation(LivingEntity entity) {
        BagusAnimationUtil.sendStopAnimation((Entity)entity, (ResourceLocation)FrostAnimations.SPEAR_ATTACK);
    }

    public boolean mineBlock(ItemStack p_43282_, Level p_43283_, BlockState p_43284_, BlockPos p_43285_, LivingEntity p_43286_) {
        if (p_43284_.getDestroySpeed((BlockGetter)p_43283_, p_43285_) != 0.0f) {
            p_43282_.hurtAndBreak(2, p_43286_, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return super.canPerformAction(stack, itemAbility);
    }
}

