/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.item.component;

import baguchan.frostrealm.aurorapower.AuroraPower;
import baguchan.frostrealm.registry.AuroraPowers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Nullable;

public class ItemAuroraPower
implements TooltipProvider {
    public static final ItemAuroraPower EMPTY = new ItemAuroraPower((Object2IntOpenHashMap<Holder<AuroraPower>>)new Object2IntOpenHashMap(), true);
    public static final int MAX_LEVEL = 255;
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)0, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<AuroraPower>>> LEVELS_CODEC = Codec.unboundedMap((Codec)AuroraPowers.getRegistry().holderByNameCodec(), LEVEL_CODEC).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemAuroraPower> FULL_CODEC = RecordCodecBuilder.create(p_337961_ -> p_337961_.group((App)LEVELS_CODEC.fieldOf("levels").forGetter(p_340785_ -> p_340785_.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(p_331891_ -> p_331891_.showInTooltip)).apply((Applicative)p_337961_, ItemAuroraPower::new));
    public static final Codec<ItemAuroraPower> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, p_340783_ -> new ItemAuroraPower((Object2IntOpenHashMap<Holder<AuroraPower>>)p_340783_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAuroraPower> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Object2IntOpenHashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)AuroraPowers.getRegistry().key()), (StreamCodec)ByteBufCodecs.VAR_INT), p_340784_ -> p_340784_.enchantments, (StreamCodec)ByteBufCodecs.BOOL, p_330450_ -> p_330450_.showInTooltip, ItemAuroraPower::new);
    final Object2IntOpenHashMap<Holder<AuroraPower>> enchantments;
    final boolean showInTooltip;

    ItemAuroraPower(Object2IntOpenHashMap<Holder<AuroraPower>> p_341287_, boolean p_330219_) {
        Object2IntMap.Entry entry;
        int i;
        this.enchantments = p_341287_;
        this.showInTooltip = p_330219_;
        ObjectIterator var3 = p_341287_.object2IntEntrySet().iterator();
        do {
            if (var3.hasNext()) continue;
            return;
        } while ((i = (entry = (Object2IntMap.Entry)var3.next()).getIntValue()) >= 0 && i <= 255);
        String var10002 = String.valueOf(entry.getKey());
        throw new IllegalArgumentException("Enchantment " + var10002 + " has invalid level " + i);
    }

    public int getLevel(AuroraPower p_330552_) {
        return this.enchantments.getInt(ItemAuroraPower.getHolder(p_330552_));
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider p_341186_, ResourceKey<Registry<T>> p_341113_, TagKey<T> p_341409_) {
        Optional optional;
        if (p_341186_ != null && (optional = p_341186_.lookupOrThrow(p_341113_).get(p_341409_)).isPresent()) {
            return (HolderSet)optional.get();
        }
        return HolderSet.direct((Holder[])new Holder[0]);
    }

    public ItemAuroraPower withTooltip(boolean p_335616_) {
        return new ItemAuroraPower(this.enchantments, p_335616_);
    }

    public Set<Holder<AuroraPower>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<AuroraPower>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object p_331697_) {
        boolean var10000;
        if (this == p_331697_) {
            return true;
        }
        if (p_331697_ instanceof ItemAuroraPower) {
            ItemAuroraPower itemenchantments = (ItemAuroraPower)p_331697_;
            var10000 = this.showInTooltip == itemenchantments.showInTooltip && this.enchantments.equals(itemenchantments.enchantments);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = this.enchantments.hashCode();
        return 31 * i + (this.showInTooltip ? 1 : 0);
    }

    public String toString() {
        String var10000 = String.valueOf(this.enchantments);
        return "ItemAuroraPower{enchantments=" + var10000 + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static Holder<AuroraPower> getHolder(AuroraPower mobEnchant) {
        return AuroraPowers.getRegistry().wrapAsHolder((Object)mobEnchant);
    }

    public void addToTooltip(Item.TooltipContext p_340892_, Consumer<Component> p_330337_, TooltipFlag p_331069_, DataComponentGetter p_399520_) {
        if (this.showInTooltip) {
            HolderLookup.Provider holderlookup$provider = p_340892_.registries();
            Registry<AuroraPower> holderset = AuroraPowers.getRegistry();
            for (AuroraPower holder : holderset) {
                int i = this.enchantments.getInt((Object)holder);
                if (i <= 0) continue;
                p_330337_.accept(holder.getFullname(i));
            }
            for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
                Holder holder1 = (Holder)entry.getKey();
                if (!holderset.containsValue((Object)((AuroraPower)holder1.value()))) continue;
                p_330337_.accept(((AuroraPower)holder1.value()).getFullname(entry.getIntValue()));
            }
        }
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<AuroraPower>> enchantments = new Object2IntOpenHashMap();
        private final boolean showInTooltip;

        public Mutable(ItemAuroraPower p_330722_) {
            this.enchantments.putAll(p_330722_.enchantments);
            this.showInTooltip = p_330722_.showInTooltip;
        }

        public void set(AuroraPower p_331872_, int p_330832_) {
            if (p_330832_ <= 0) {
                this.enchantments.removeInt(ItemAuroraPower.getHolder(p_331872_));
            } else {
                this.enchantments.put(ItemAuroraPower.getHolder(p_331872_), Math.min(p_330832_, 255));
            }
        }

        public void upgrade(AuroraPower p_330536_, int p_331153_) {
            if (p_331153_ > 0) {
                this.enchantments.merge(ItemAuroraPower.getHolder(p_330536_), Math.min(p_331153_, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<AuroraPower>> p_332079_) {
            this.enchantments.keySet().removeIf(p_332079_);
        }

        public int getLevel(AuroraPower p_331330_) {
            return this.enchantments.getOrDefault(ItemAuroraPower.getHolder(p_331330_), 0);
        }

        public Set<Holder<AuroraPower>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemAuroraPower toImmutable() {
            return new ItemAuroraPower(this.enchantments, this.showInTooltip);
        }
    }
}

