/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.loot;

import baguchan.frostrealm.registry.FrostLootFunctions;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class AuroraWithLevelsFunction
extends LootItemConditionalFunction {
    public static final MapCodec<AuroraWithLevelsFunction> CODEC = RecordCodecBuilder.mapCodec(p_344692_ -> AuroraWithLevelsFunction.commonFields((RecordCodecBuilder.Instance)p_344692_).and((App)NumberProviders.CODEC.fieldOf("levels").forGetter(p_298844_ -> p_298844_.levels)).apply((Applicative)p_344692_, AuroraWithLevelsFunction::new));
    private final NumberProvider levels;

    AuroraWithLevelsFunction(List<LootItemCondition> condtions, NumberProvider levels) {
        super(condtions);
        this.levels = levels;
    }

    public LootItemFunctionType<AuroraWithLevelsFunction> getType() {
        return (LootItemFunctionType)FrostLootFunctions.AURORA_WITH_LEVEL.get();
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.levels.getReferencedContextParams();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        RandomSource randomsource = context.getRandom();
        return AuroraPowerUtils.auroraInfusionItem(randomsource, stack, this.levels.getInt(context), true);
    }

    public static Builder enchantWithLevels(HolderLookup.Provider registries, NumberProvider levels) {
        return new Builder(levels);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider levels;

        public Builder(NumberProvider levels) {
            this.levels = levels;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new AuroraWithLevelsFunction(this.getConditions(), this.levels);
        }
    }
}

