/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.registry;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.block.AuroraInfuserBlock;
import baguchan.frostrealm.block.ColdTallGrassBlock;
import baguchan.frostrealm.block.FrostCampfireBlock;
import baguchan.frostrealm.block.FrostFireBlock;
import baguchan.frostrealm.block.FrostGrassBlock;
import baguchan.frostrealm.block.FrostPortalBlock;
import baguchan.frostrealm.block.FrostTorchBlock;
import baguchan.frostrealm.block.FrozenFarmBlock;
import baguchan.frostrealm.block.MagmaCoreBlock;
import baguchan.frostrealm.block.PermaMagmaBlock;
import baguchan.frostrealm.block.PointedIceBlock;
import baguchan.frostrealm.block.SilkMoonCocoonBlock;
import baguchan.frostrealm.block.SilkMoonEggBlock;
import baguchan.frostrealm.block.SnowPileQuailEggBlock;
import baguchan.frostrealm.block.VigoroMushroomBlock;
import baguchan.frostrealm.block.WallFrostTorchBlock;
import baguchan.frostrealm.block.WolfflueBlock;
import baguchan.frostrealm.block.crop.BearBerryBushBlock;
import baguchan.frostrealm.block.crop.RyeBlock;
import baguchan.frostrealm.block.crop.SugarBeetBlock;
import baguchan.frostrealm.item.block.DeferredDoubleHighBlockItem;
import baguchan.frostrealm.registry.FrostBlockSetTypes;
import baguchan.frostrealm.registry.FrostEffects;
import baguchan.frostrealm.registry.FrostFluids;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostWoodTypes;
import baguchan.frostrealm.world.tree.FrostTrees;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FrostBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"frostrealm");
    public static final DeferredBlock<LiquidBlock> HOT_SPRING = FrostBlocks.registerWithoutItem("hot_spring", properties -> new LiquidBlock((FlowingFluid)FrostFluids.HOT_SPRING.value(), properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollision().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    public static final DeferredBlock<FrostPortalBlock> FROST_PORTAL = FrostBlocks.registerWithoutItem("frostrealm_portal", properties -> new FrostPortalBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().noCollision().randomTicks().lightLevel(state -> 11).strength(-1.0f).sound(SoundType.GLASS));
    public static final DeferredBlock<Block> FROZEN_DIRT = FrostBlocks.register("frozen_dirt", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.GRAVEL));
    public static final DeferredBlock<Block> FROZEN_GRASS_BLOCK = FrostBlocks.register("frozen_grass_block", properties -> new FrostGrassBlock((BlockBehaviour.Properties)properties, (Supplier<Block>)FROZEN_DIRT), () -> BlockBehaviour.Properties.of().randomTicks().strength(0.6f).sound(SoundType.GRASS));
    public static final DeferredBlock<Block> FROZEN_FARMLAND = FrostBlocks.register("frozen_farmland", properties -> new FrozenFarmBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(0.5f).randomTicks().sound(SoundType.GRAVEL));
    public static final DeferredBlock<Block> POINTED_ICE = FrostBlocks.register("pointed_ice", properties -> new PointedIceBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().friction(0.98f).randomTicks().strength(0.5f).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ).sound(SoundType.GLASS));
    public static final DeferredBlock<Block> PERMA_SLATE = FrostBlocks.register("perma_slate", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.75f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> PERMA_SLATE_SMOOTH = FrostBlocks.register("perma_slate_smooth", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.75f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> PERMA_SLATE_BRICK = FrostBlocks.register("perma_slate_brick", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.75f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_BRICKS));
    public static final DeferredBlock<SlabBlock> PERMA_SLATE_BRICK_SLAB = FrostBlocks.register("perma_slate_brick_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.75f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_BRICKS));
    public static final DeferredBlock<StairBlock> PERMA_SLATE_BRICK_STAIRS = FrostBlocks.register("perma_slate_brick_stairs", properties -> new StairBlock(((Block)PERMA_SLATE_BRICK.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).strength(1.75f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE_BRICKS));
    public static final DeferredBlock<WallBlock> PERMA_SLATE_BRICK_WALL = FrostBlocks.register("perma_slate_brick_wall", properties -> new WallBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.75f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> PERMA_MAGMA = FrostBlocks.register("perma_magma", properties -> new PermaMagmaBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.0f, 3.0f).isValidSpawn((p_187421_, p_187422_, p_187423_, p_187424_) -> p_187424_.fireImmune()).hasPostProcess(FrostBlocks::always));
    public static final DeferredBlock<Block> FRIGID_STONE = FrostBlocks.register("frigid_stone", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> FRIGID_GRASS_BLOCK = FrostBlocks.register("frigid_grass_block", properties -> new FrostGrassBlock((BlockBehaviour.Properties)properties, (Supplier<Block>)FRIGID_STONE), () -> BlockBehaviour.Properties.of().randomTicks().requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.NYLIUM));
    public static final DeferredBlock<SlabBlock> FRIGID_STONE_SLAB = FrostBlocks.register("frigid_stone_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<StairBlock> FRIGID_STONE_STAIRS = FrostBlocks.register("frigid_stone_stairs", properties -> new StairBlock(((Block)FRIGID_STONE.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> FRIGID_STONE_BRICK = FrostBlocks.register("frigid_stone_brick", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<SlabBlock> FRIGID_STONE_BRICK_SLAB = FrostBlocks.register("frigid_stone_brick_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<StairBlock> FRIGID_STONE_BRICK_STAIRS = FrostBlocks.register("frigid_stone_brick_stairs", properties -> new StairBlock(((Block)FRIGID_STONE_BRICK.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<WallBlock> FRIGID_STONE_BRICK_WALL = FrostBlocks.register("frigid_stone_brick_wall", properties -> new WallBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> FRIGID_STONE_SMOOTH = FrostBlocks.register("frigid_stone_smooth", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> CHISELED_FRIGID_STONE_BRICK = FrostBlocks.register("chiseled_frigid_stone_brick", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> MAGMA_CORE = FrostBlocks.register("magma_core", properties -> new MagmaCoreBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 100.0f));
    public static final DeferredBlock<Block> FRIGID_STONE_MOSSY = FrostBlocks.register("frigid_stone_mossy", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<SlabBlock> FRIGID_STONE_MOSSY_SLAB = FrostBlocks.register("frigid_stone_mossy_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<StairBlock> FRIGID_STONE_MOSSY_STAIRS = FrostBlocks.register("frigid_stone_mossy_stairs", properties -> new StairBlock(((Block)FRIGID_STONE_MOSSY.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> FRIGID_STONE_BRICK_MOSSY = FrostBlocks.register("frigid_stone_brick_mossy", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<SlabBlock> FRIGID_STONE_BRICK_MOSSY_SLAB = FrostBlocks.register("frigid_stone_brick_mossy_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<StairBlock> FRIGID_STONE_BRICK_MOSSY_STAIRS = FrostBlocks.register("frigid_stone_brick_mossy_stairs", properties -> new StairBlock(((Block)FRIGID_STONE_BRICK_MOSSY.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().strength(1.5f, 6.0f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> SHERBET_SAND = FrostBlocks.register("sherbet_sand", properties -> new ColoredFallingBlock(new ColorRGBA(16759275), properties), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
    public static final DeferredBlock<Block> SHERBET_SANDSTONE = FrostBlocks.register("sherbet_sandstone", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(0.8f).requiresCorrectToolForDrops().sound(SoundType.STONE));
    public static final DeferredBlock<SlabBlock> SHERBET_SANDSTONE_SLAB = FrostBlocks.register("sherbet_sandstone_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().strength(0.8f).noOcclusion().requiresCorrectToolForDrops().sound(SoundType.STONE));
    public static final DeferredBlock<StairBlock> SHERBET_SANDSTONE_STAIRS = FrostBlocks.register("sherbet_sandstone_stairs", properties -> new StairBlock(((Block)FRIGID_STONE.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(0.8f).requiresCorrectToolForDrops().sound(SoundType.STONE));
    public static final DeferredBlock<RotatedPillarBlock> FROSTROOT_LOG = FrostBlocks.register("frostroot_log", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f).sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_FROSTROOT_LOG = FrostBlocks.register("stripped_frostroot_log", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f).sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<LeavesBlock> FROSTROOT_LEAVES = FrostBlocks.register("frostroot_leaves", properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)5196924), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(0.2f).noOcclusion().isSuffocating(FrostBlocks::never).isViewBlocking(FrostBlocks::never).sound(SoundType.GRASS));
    public static final DeferredBlock<DoublePlantBlock> COLD_TALL_GRASS = FrostBlocks.registerDoubleBlockItem("cold_tall_grass", properties -> new DoublePlantBlock(properties.noOcclusion().noCollision().replaceable().sound(SoundType.GRASS)), BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> FROSTROOT_PLANKS = FrostBlocks.register("frostroot_planks", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<SlabBlock> FROSTROOT_PLANKS_SLAB = FrostBlocks.register("frostroot_planks_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<StairBlock> FROSTROOT_PLANKS_STAIRS = FrostBlocks.register("frostroot_planks_stairs", properties -> new StairBlock(((Block)FROSTROOT_PLANKS.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<FenceBlock> FROSTROOT_FENCE = FrostBlocks.register("frostroot_fence", properties -> new FenceBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<FenceGateBlock> FROSTROOT_FENCE_GATE = FrostBlocks.register("frostroot_fence_gate", properties -> new FenceGateBlock(FrostWoodTypes.FROSTROOT, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<DoorBlock> FROSTROOT_DOOR = FrostBlocks.register("frostroot_door", properties -> new DoorBlock(FrostBlockSetTypes.FROSTROOT, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<TrapDoorBlock> FROSTROOT_TRAPDOOR = FrostBlocks.register("frostroot_trapdoor", properties -> new TrapDoorBlock(FrostBlockSetTypes.FROSTROOT, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).strength(3.0f).noOcclusion().sound(SoundType.CHERRY_WOOD));
    public static final DeferredBlock<ButtonBlock> FROSTROOT_BUTTON = FrostBlocks.register("frostroot_button", properties -> FrostBlocks.woodenButton(properties, FrostBlockSetTypes.FROSTBITE), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> BEARBERRY_BUSH = FrostBlocks.registerWithoutItem("bearberry_bush", properties -> new BearBerryBushBlock(properties.noOcclusion().noCollision().sound(SoundType.GRASS)), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<RotatedPillarBlock> FROSTBITE_LOG = FrostBlocks.register("frostbite_log", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f).randomTicks().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_FROSTBITE_LOG = FrostBlocks.register("stripped_frostbite_log", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f).sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<LeavesBlock> FROSTBITE_LEAVES = FrostBlocks.register("frostbite_leaves", properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)5402512), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(0.2f).noOcclusion().isSuffocating(FrostBlocks::never).isViewBlocking(FrostBlocks::never).sound(SoundType.GRASS));
    public static final DeferredBlock<Block> SUGARBEET = FrostBlocks.registerWithoutItem("sugarbeet", properties -> new SugarBeetBlock(properties.noOcclusion().noCollision().sound(SoundType.CROP)), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> FROSTBITE_PLANKS = FrostBlocks.register("frostbite_planks", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<SlabBlock> FROSTBITE_PLANKS_SLAB = FrostBlocks.register("frostbite_planks_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<StairBlock> FROSTBITE_PLANKS_STAIRS = FrostBlocks.register("frostbite_planks_stairs", properties -> new StairBlock(((Block)FROSTBITE_PLANKS.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<FenceBlock> FROSTBITE_FENCE = FrostBlocks.register("frostbite_fence", properties -> new FenceBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<FenceGateBlock> FROSTBITE_FENCE_GATE = FrostBlocks.register("frostbite_fence_gate", properties -> new FenceGateBlock(FrostWoodTypes.FROSTBITE, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<DoorBlock> FROSTBITE_DOOR = FrostBlocks.register("frostbite_door", properties -> new DoorBlock(FrostBlockSetTypes.FROSTBITE, properties), () -> BlockBehaviour.Properties.of().strength(3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<TrapDoorBlock> FROSTBITE_TRAPDOOR = FrostBlocks.register("frostbite_trapdoor", properties -> new TrapDoorBlock(FrostBlockSetTypes.FROSTBITE, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).strength(3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<ButtonBlock> FROSTBITE_BUTTON = FrostBlocks.register("frostbite_button", properties -> FrostBlocks.woodenButton(properties, FrostBlockSetTypes.FROSTBITE), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> RYE = FrostBlocks.registerWithoutItem("rye", properties -> new RyeBlock(properties.noOcclusion().noCollision().sound(SoundType.CROP)), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<RotatedPillarBlock> ROCK_WOOD = FrostBlocks.register("rock_wood", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f).sound(SoundType.CALCITE));
    public static final DeferredBlock<Block> ROCK_WOOD_PLANKS = FrostBlocks.register("rock_wood_planks", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 5.0f).sound(SoundType.CALCITE));
    public static final DeferredBlock<SlabBlock> ROCK_WOOD_PLANKS_SLAB = FrostBlocks.register("rock_wood_planks_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 5.0f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<StairBlock> ROCK_WOOD_PLANKS_STAIRS = FrostBlocks.register("rock_wood_planks_stairs", properties -> new StairBlock(((Block)ROCK_WOOD_PLANKS.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 5.0f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<FenceBlock> ROCK_WOOD_FENCE = FrostBlocks.register("rock_wood_fence", properties -> new FenceBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 3.5f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<FenceGateBlock> ROCK_WOOD_FENCE_GATE = FrostBlocks.register("rock_wood_fence_gate", properties -> new FenceGateBlock(FrostWoodTypes.ROCK_WOOD, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 5.0f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<DoorBlock> ROCK_WOOD_DOOR = FrostBlocks.register("rock_wood_door", properties -> new DoorBlock(FrostBlockSetTypes.ROCK_WOOD, properties), () -> BlockBehaviour.Properties.of().strength(2.25f, 5.0f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<TrapDoorBlock> ROCK_WOOD_TRAPDOOR = FrostBlocks.register("rock_wood_trapdoor", properties -> new TrapDoorBlock(FrostBlockSetTypes.ROCK_WOOD, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(2.25f, 5.0f).noOcclusion().sound(SoundType.CALCITE));
    public static final DeferredBlock<ButtonBlock> ROCK_WOOD_BUTTON = FrostBlocks.register("rock_wood_button", properties -> FrostBlocks.rockWoodButton(properties, FrostBlockSetTypes.ROCK_WOOD), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<Block> WALL_FROST_TORCH = FrostBlocks.registerWithoutItem("wall_frost_torch", properties -> new WallFrostTorchBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(p_220871_ -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<RotatedPillarBlock> DRIP_LOG = FrostBlocks.register("drip_log", properties -> new RotatedPillarBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f).sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<LeavesBlock> DRIP_LEAVES = FrostBlocks.register("drip_leaves", properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)12076839), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(0.2f).noOcclusion().isSuffocating(FrostBlocks::never).isViewBlocking(FrostBlocks::never).sound(SoundType.GRASS));
    public static final DeferredBlock<Block> FROST_TORCH = FrostBlocks.registerTorchBlock("frost_torch", properties -> new FrostTorchBlock((BlockBehaviour.Properties)properties), WALL_FROST_TORCH, BlockBehaviour.Properties.of().noCollision().instabreak().lightLevel(p_220871_ -> 14).sound(SoundType.WOOD).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> DRIP_PLANKS = FrostBlocks.register("drip_planks", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<SlabBlock> DRIP_PLANKS_SLAB = FrostBlocks.register("drip_planks_slab", properties -> new SlabBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<StairBlock> DRIP_PLANKS_STAIRS = FrostBlocks.register("drip_planks_stairs", properties -> new StairBlock(((Block)DRIP_PLANKS.get()).defaultBlockState(), properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<FenceBlock> DRIP_FENCE = FrostBlocks.register("drip_fence", properties -> new FenceBlock(properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<FenceGateBlock> DRIP_FENCE_GATE = FrostBlocks.register("drip_fence_gate", properties -> new FenceGateBlock(FrostWoodTypes.DRIP, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(2.0f, 3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<DoorBlock> DRIP_DOOR = FrostBlocks.register("drip_door", properties -> new DoorBlock(FrostBlockSetTypes.DRIP, properties), () -> BlockBehaviour.Properties.of().strength(3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<TrapDoorBlock> DRIP_TRAPDOOR = FrostBlocks.register("drip_trapdoor", properties -> new TrapDoorBlock(FrostBlockSetTypes.DRIP, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).strength(3.0f).noOcclusion().sound(SoundType.NETHER_WOOD));
    public static final DeferredBlock<ButtonBlock> DRIP_BUTTON = FrostBlocks.register("drip_button", properties -> FrostBlocks.woodenButton(properties, FrostBlockSetTypes.DRIP), () -> BlockBehaviour.Properties.of());
    public static final DeferredBlock<SaplingBlock> FROSTROOT_SAPLING = FrostBlocks.register("frostroot_sapling", properties -> new SaplingBlock(FrostTrees.FROSTROOT, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.PURPLE).randomTicks().noCollision().noOcclusion().sound(SoundType.GRASS));
    public static final DeferredBlock<PressurePlateBlock> FROSTROOT_PRESSURE_PLATE = FrostBlocks.register("frostroot_pressure_plate", properties -> new PressurePlateBlock(FrostBlockSetTypes.FROSTROOT, properties), () -> BlockBehaviour.Properties.of().mapColor(((Block)FROSTROOT_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<SaplingBlock> FROSTBITE_SAPLING = FrostBlocks.register("frostbite_sapling", properties -> new SaplingBlock(FrostTrees.FROSTBITE, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.CYAN).randomTicks().noCollision().noOcclusion().sound(SoundType.GRASS));
    public static final DeferredBlock<PressurePlateBlock> FROSTBITE_PRESSURE_PLATE = FrostBlocks.register("frostbite_pressure_plate", properties -> new PressurePlateBlock(FrostBlockSetTypes.FROSTBITE, properties), () -> BlockBehaviour.Properties.of().mapColor(((Block)FROSTBITE_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<PressurePlateBlock> ROCK_WOOD_PRESSURE_PLATE = FrostBlocks.register("rock_wood_pressure_plate", properties -> new PressurePlateBlock(FrostBlockSetTypes.ROCK_WOOD, properties), () -> BlockBehaviour.Properties.of().mapColor(((Block)ROCK_WOOD_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f, 2.5f).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<SaplingBlock> DRIP_SAPLING = FrostBlocks.register("drip_sapling", properties -> new SaplingBlock(FrostTrees.DRIP, properties), () -> BlockBehaviour.Properties.of().mapColor(DyeColor.BROWN).randomTicks().noCollision().noOcclusion().sound(SoundType.GRASS));
    public static final DeferredBlock<PressurePlateBlock> DRIP_PRESSURE_PLATE = FrostBlocks.register("drip_pressure_plate", properties -> new PressurePlateBlock(FrostBlockSetTypes.DRIP, properties), () -> BlockBehaviour.Properties.of().mapColor(((Block)DRIP_PLANKS.get()).defaultMapColor()).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollision().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> VIGOROSHROOM = FrostBlocks.register("vigoroshroom", properties -> new VigoroMushroomBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().noCollision().lightLevel(state -> 10).sound(SoundType.GRASS));
    public static final DeferredBlock<Block> ARCTIC_POPPY = FrostBlocks.register("arctic_poppy", properties -> new FlowerBlock(FrostEffects.COLD_RESISTANCE, 200.0f, properties), () -> BlockBehaviour.Properties.of().noOcclusion().noCollision().sound(SoundType.GRASS));
    public static final DeferredBlock<Block> RYE_BLOCK = FrostBlocks.register("rye_block", properties -> new HayBlock(properties), () -> BlockBehaviour.Properties.of().sound(SoundType.GRASS));
    public static final DeferredBlock<Block> SNOWPILE_QUAIL_EGG = FrostBlocks.register("snowpile_quail_egg", properties -> new SnowPileQuailEggBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(0.2f, 0.25f).sound(SoundType.METAL));
    public static final DeferredBlock<Block> SILK_MOON_EGG = FrostBlocks.register("silk_moon_egg", properties -> new SilkMoonEggBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(0.2f, 0.25f).sound(SoundType.METAL));
    public static final DeferredBlock<Block> SILK_MOON_COCOON = FrostBlocks.register("silk_moon_cocoon", properties -> new SilkMoonCocoonBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().strength(0.75f).sound(SoundType.WOOL));
    public static final DeferredBlock<Block> FROST_CRYSTAL_ORE = FrostBlocks.register("frost_crystal_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)2), properties), () -> BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> GLIMMERROCK_ORE = FrostBlocks.register("glimmerrock_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), properties), () -> BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> ASTRIUM_ORE = FrostBlocks.register("astrium_ore", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> FROST_CRYSTAL_SLATE_ORE = FrostBlocks.register("frost_crystal_slate_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)2), properties), () -> BlockBehaviour.Properties.of().strength(4.5f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> GLIMMERROCK_SLATE_ORE = FrostBlocks.register("glimmerrock_slate_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), properties), () -> BlockBehaviour.Properties.of().strength(4.5f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> ASTRIUM_SLATE_ORE = FrostBlocks.register("astrium_slate_ore", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(4.6f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> FROST_CRYSTAL_BLOCK = FrostBlocks.register("frost_crystal_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL));
    public static final DeferredBlock<Block> ASTRIUM_BLOCK = FrostBlocks.register("astrium_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> RAW_ASTRIUM_BLOCK = FrostBlocks.register("raw_astrium_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK));
    public static final DeferredBlock<Block> GLIMMERROCK_BLOCK = FrostBlocks.register("glimmerrock_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL));
    public static final DeferredBlock<Block> GLACINIUM_ORE = FrostBlocks.register("glacinium_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), properties), () -> BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(10.0f, 100.0f).sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> RAW_GLACINIUM_BLOCK = FrostBlocks.register("raw_glacinium_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(15.0f, 100.0f).sound(SoundType.GLASS));
    public static final DeferredBlock<Block> GLACINIUM_BLOCK = FrostBlocks.register("glacinium_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(15.0f, 100.0f).sound(SoundType.GLASS));
    public static final DeferredBlock<Block> STARDUST_CRYSTAL_ORE = FrostBlocks.register("stardust_crystal_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), properties), () -> BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERRACK));
    public static final DeferredBlock<Block> STARDUST_CRYSTAL_CLUSTER = FrostBlocks.register("stardust_crystal_cluster", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().isSuffocating(FrostBlocks::never).requiresCorrectToolForDrops().lightLevel(state -> 10).strength(5.0f, 6.0f).noOcclusion().sound(SoundType.DEEPSLATE));
    public static final DeferredBlock<Block> WARPED_CRYSTAL_BLOCK = FrostBlocks.register("warped_crystal_block", properties -> new Block(properties), () -> BlockBehaviour.Properties.of().requiresCorrectToolForDrops().lightLevel(state -> 12).strength(5.0f, 6.0f).noOcclusion().sound(SoundType.GLASS));
    public static final DeferredBlock<Block> ARCTIC_WILLOW = FrostBlocks.register("arctic_willow", properties -> new FlowerBlock(FrostEffects.COLD_RESISTANCE, 200.0f, properties), () -> BlockBehaviour.Properties.of().noOcclusion().noCollision().sound(SoundType.GRASS));
    public static final DeferredBlock<Block> COLD_GRASS = FrostBlocks.register("cold_grass", properties -> new ColdTallGrassBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().noOcclusion().noCollision().replaceable().sound(SoundType.GRASS));
    public static final DeferredBlock<Block> FROST_CAMPFIRE = FrostBlocks.register("frost_campfire", properties -> new FrostCampfireBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().strength(2.0f).noOcclusion().lightLevel(FrostBlocks.litBlockEmission(13)).sound(SoundType.WOOD));
    public static final DeferredBlock<Block> FROST_FIRE = FrostBlocks.registerWithoutItem("frost_fire", prop -> new FrostFireBlock((BlockBehaviour.Properties)prop), () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).replaceable().noCollision().instabreak().lightLevel(p_50755_ -> 10).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    public static final DeferredBlock<Block> AURORA_INFUSER = FrostBlocks.register("aurora_infuser", properties -> new AuroraInfuserBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(2.0f, 3.0f).sound(SoundType.METAL));
    public static final DeferredBlock<Block> WOLFFLUE_BLOCK = FrostBlocks.register("wolfflue_block", properties -> new WolfflueBlock((BlockBehaviour.Properties)properties), () -> BlockBehaviour.Properties.of().strength(5.0f, 5.0f).sound(SoundType.WOOL));

    private static <T extends Block> DeferredBlock<Block> registerWithoutItem(String name, Supplier<BlockBehaviour.Properties> properties) {
        return FrostBlocks.registerWithoutItem(name, Block::new, properties);
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return FrostBlocks.registerWithoutItem(name, FrostBlocks.createKey(name), builder, properties);
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return BLOCKS.register(name, () -> (Block)builder.apply(((BlockBehaviour.Properties)properties.get()).setId(key)));
    }

    private static <T extends Block> DeferredBlock<Block> register(String name, Supplier<BlockBehaviour.Properties> properties) {
        return FrostBlocks.register(name, Block::new, properties);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return FrostBlocks.register(name, FrostBlocks.createKey(name), builder, properties);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties) {
        return FrostBlocks.baseRegister(name, key, builder, properties, deferredBlock -> FrostBlocks.registerBlockItem(deferredBlock, name));
    }

    private static ResourceKey<Block> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name));
    }

    private static <T extends Block> DeferredBlock<T> baseRegister(String name, ResourceKey<Block> key, Function<BlockBehaviour.Properties, T> builder, Supplier<BlockBehaviour.Properties> properties, Function<DeferredBlock<T>, Supplier<? extends Item>> item) {
        DeferredBlock registered = BLOCKS.register(name, () -> (Block)builder.apply(((BlockBehaviour.Properties)properties.get()).setId(key)));
        FrostItems.ITEMS.register(name, item.apply(registered));
        return registered;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int p_50760_) {
        return p_50763_ -> (Boolean)p_50763_.getValue((Property)BlockStateProperties.LIT) != false ? p_50760_ : 0;
    }

    private static ButtonBlock woodenButton(BlockBehaviour.Properties properties, BlockSetType p_278239_) {
        return new ButtonBlock(p_278239_, 30, properties.noCollision().strength(0.5f).pushReaction(PushReaction.DESTROY));
    }

    private static ButtonBlock rockWoodButton(BlockBehaviour.Properties properties, BlockSetType p_278239_) {
        return new ButtonBlock(p_278239_, 30, properties.noCollision().strength(0.5f, 2.5f).pushReaction(PushReaction.DESTROY));
    }

    private static boolean always(BlockState p_50775_, BlockGetter p_50776_, BlockPos p_50777_) {
        return true;
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    public static void burnables() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)FROSTROOT_SAPLING.get(), 60, 100);
        fireblock.setFlammable((Block)FROSTROOT_LEAVES.get(), 60, 100);
        fireblock.setFlammable((Block)FROSTROOT_LOG.get(), 5, 5);
        fireblock.setFlammable((Block)STRIPPED_FROSTROOT_LOG.get(), 5, 5);
        fireblock.setFlammable((Block)FROSTROOT_PLANKS.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_PLANKS_SLAB.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_PLANKS_STAIRS.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_FENCE.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_FENCE_GATE.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_DOOR.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTROOT_TRAPDOOR.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_SAPLING.get(), 60, 100);
        fireblock.setFlammable((Block)FROSTBITE_LEAVES.get(), 60, 100);
        fireblock.setFlammable((Block)FROSTBITE_LOG.get(), 5, 5);
        fireblock.setFlammable((Block)STRIPPED_FROSTBITE_LOG.get(), 5, 5);
        fireblock.setFlammable((Block)FROSTBITE_PLANKS.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_PLANKS_SLAB.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_PLANKS_STAIRS.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_FENCE.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_FENCE_GATE.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_DOOR.get(), 5, 20);
        fireblock.setFlammable((Block)FROSTBITE_TRAPDOOR.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_SAPLING.get(), 60, 100);
        fireblock.setFlammable((Block)DRIP_LEAVES.get(), 60, 100);
        fireblock.setFlammable((Block)DRIP_LOG.get(), 5, 5);
        fireblock.setFlammable((Block)DRIP_PLANKS.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_PLANKS_SLAB.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_PLANKS_STAIRS.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_FENCE.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_FENCE_GATE.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_DOOR.get(), 5, 20);
        fireblock.setFlammable((Block)DRIP_TRAPDOOR.get(), 5, 20);
        fireblock.setFlammable((Block)COLD_TALL_GRASS.get(), 60, 100);
        fireblock.setFlammable((Block)RYE_BLOCK.get(), 60, 20);
    }

    public static <T extends Block> DeferredBlock<T> registerDoubleBlockItem(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties) {
        DeferredBlock ret = BLOCKS.register(name, () -> (Block)block.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FrostRealm.prefix(name)))));
        FrostItems.ITEMS.registerItem(name, itemProps -> new DeferredDoubleHighBlockItem((DeferredBlock<? extends Block>)ret, itemProps.useBlockDescriptionPrefix()), new Item.Properties());
        return ret;
    }

    private static <T extends Block> DeferredBlock<T> registerTorchBlock(String name, Function<BlockBehaviour.Properties, T> block, DeferredBlock<T> wallTorchBlock, BlockBehaviour.Properties properties) {
        DeferredBlock ret = BLOCKS.register(name, () -> (Block)block.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FrostRealm.prefix(name)))));
        FrostItems.ITEMS.registerItem(name, itemProps -> new StandingAndWallBlockItem((Block)ret.get(), (Block)wallTorchBlock.get(), Direction.DOWN, itemProps.useBlockDescriptionPrefix()), new Item.Properties());
        return ret;
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(DeferredBlock<T> deferredBlock, String name) {
        return () -> {
            DeferredBlock block = Objects.requireNonNull(deferredBlock);
            Item.Properties properties = new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)name))).useBlockDescriptionPrefix();
            if (block == FROST_TORCH) {
                return new StandingAndWallBlockItem((Block)FROST_TORCH.get(), (Block)WALL_FROST_TORCH.get(), Direction.DOWN, properties);
            }
            return new BlockItem((Block)block.get(), properties);
        };
    }
}

