/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.registry;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.entity.Yeti;
import baguchan.frostrealm.entity.animal.CrystalFox;
import baguchan.frostrealm.entity.animal.Ferret;
import baguchan.frostrealm.entity.animal.FrostAnimal;
import baguchan.frostrealm.entity.animal.FrostBoar;
import baguchan.frostrealm.entity.animal.Marmot;
import baguchan.frostrealm.entity.animal.Seal;
import baguchan.frostrealm.entity.animal.SilkMoon;
import baguchan.frostrealm.entity.animal.SilkMoonWorm;
import baguchan.frostrealm.entity.animal.SnowMole;
import baguchan.frostrealm.entity.animal.SnowPileQuail;
import baguchan.frostrealm.entity.animal.Wolfflue;
import baguchan.frostrealm.entity.boss.Seeker;
import baguchan.frostrealm.entity.hostile.AstraBall;
import baguchan.frostrealm.entity.hostile.FrostWraith;
import baguchan.frostrealm.entity.hostile.Gokkur;
import baguchan.frostrealm.entity.hostile.LesserWarrior;
import baguchan.frostrealm.entity.hostile.RootDeer;
import baguchan.frostrealm.entity.hostile.UnderGokkur;
import baguchan.frostrealm.entity.hostile.Venochem;
import baguchan.frostrealm.entity.hostile.WarpedMonster;
import baguchan.frostrealm.entity.projectile.FlyingBlockEntity;
import baguchan.frostrealm.entity.projectile.VenomBall;
import baguchan.frostrealm.registry.FrostMobCategory;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="frostrealm")
public class FrostEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"frostrealm");
    public static final DeferredHolder<EntityType<?>, EntityType<Marmot>> MARMOT = ENTITIES.register("marmot", () -> EntityType.Builder.of(Marmot::new, (MobCategory)MobCategory.CREATURE).sized(0.65f, 0.6f).eyeHeight(0.4f).build(FrostEntities.prefix("marmot")));
    public static final DeferredHolder<EntityType<?>, EntityType<SnowPileQuail>> SNOWPILE_QUAIL = ENTITIES.register("snowpile_quail", () -> EntityType.Builder.of(SnowPileQuail::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.6f).eyeHeight(0.4f).build(FrostEntities.prefix("snowpile_quail")));
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalFox>> CRYSTAL_FOX = ENTITIES.register("crystal_fox", () -> EntityType.Builder.of(CrystalFox::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.7f).eyeHeight(0.4f).clientTrackingRange(8).build(FrostEntities.prefix("crystal_fox")));
    public static final DeferredHolder<EntityType<?>, EntityType<SnowMole>> SNOW_MOLE = ENTITIES.register("snow_mole", () -> EntityType.Builder.of(SnowMole::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 0.6f).eyeHeight(0.3f).clientTrackingRange(8).immuneTo(new Block[]{Blocks.POWDER_SNOW}).immuneTo(new Block[]{Blocks.POWDER_SNOW_CAULDRON}).build(FrostEntities.prefix("snow_mole")));
    public static final DeferredHolder<EntityType<?>, EntityType<Seal>> SEAL = ENTITIES.register("seal", () -> EntityType.Builder.of(Seal::new, (MobCategory)MobCategory.CREATURE).sized(0.95f, 0.8f).eyeHeight(0.45f).clientTrackingRange(10).build(FrostEntities.prefix("seal")));
    public static final DeferredHolder<EntityType<?>, EntityType<Wolfflue>> WOLFFLUE = ENTITIES.register("wolfflue", () -> EntityType.Builder.of(Wolfflue::new, (MobCategory)MobCategory.CREATURE).sized(1.25f, 1.4f).eyeHeight(1.2f).clientTrackingRange(10).build(FrostEntities.prefix("wolfflue")));
    public static final DeferredHolder<EntityType<?>, EntityType<Ferret>> FERRET = ENTITIES.register("ferret", () -> EntityType.Builder.of(Ferret::new, (MobCategory)MobCategory.CREATURE).sized(1.0f, 0.4f).eyeHeight(0.3f).clientTrackingRange(10).build(FrostEntities.prefix("ferret")));
    public static final DeferredHolder<EntityType<?>, EntityType<SilkMoonWorm>> SILK_MOON_WORM = ENTITIES.register("silk_moon_worm", () -> EntityType.Builder.of(SilkMoonWorm::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.3f).eyeHeight(0.15f).clientTrackingRange(10).build(FrostEntities.prefix("silk_moon_worm")));
    public static final DeferredHolder<EntityType<?>, EntityType<SilkMoon>> SILK_MOON = ENTITIES.register("silk_moon", () -> EntityType.Builder.of(SilkMoon::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.5f).eyeHeight(0.35f).clientTrackingRange(10).build(FrostEntities.prefix("silk_moon")));
    public static final DeferredHolder<EntityType<?>, EntityType<Yeti>> YETI = ENTITIES.register("yeti", () -> EntityType.Builder.of(Yeti::new, (MobCategory)MobCategory.CREATURE).sized(1.6f, 1.95f).eyeHeight(1.75f).build(FrostEntities.prefix("yeti")));
    public static final DeferredHolder<EntityType<?>, EntityType<FrostWraith>> FROST_WRAITH = ENTITIES.register("frost_wraith", () -> EntityType.Builder.of(FrostWraith::new, (MobCategory)FrostMobCategory.FROSTREALM_WEATHER_MONSTER).sized(0.6f, 2.1f).notInPeaceful().build(FrostEntities.prefix("frost_wraith")));
    public static final DeferredHolder<EntityType<?>, EntityType<LesserWarrior>> LESSER_WARRIOR = ENTITIES.register("lesser_warrior", () -> EntityType.Builder.of(LesserWarrior::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.99f).notInPeaceful().immuneTo(new Block[]{Blocks.POWDER_SNOW}).clientTrackingRange(8).build(FrostEntities.prefix("lesser_warrior")));
    public static final DeferredHolder<EntityType<?>, EntityType<AstraBall>> ASTRA_BALL = ENTITIES.register("astra_ball", () -> EntityType.Builder.of(AstraBall::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 0.5f).notInPeaceful().eyeHeight(0.25f).build(FrostEntities.prefix("astra_ball")));
    public static final DeferredHolder<EntityType<?>, EntityType<FrostBoar>> FROST_BOAR = ENTITIES.register("frost_boar", () -> EntityType.Builder.of(FrostBoar::new, (MobCategory)MobCategory.CREATURE).sized(1.8f, 1.95f).eyeHeight(1.5f).build(FrostEntities.prefix("frost_boar")));
    public static final DeferredHolder<EntityType<?>, EntityType<Venochem>> VENOCHEM = ENTITIES.register("venochem", () -> EntityType.Builder.of(Venochem::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 0.8f).notInPeaceful().eyeHeight(0.45f).build(FrostEntities.prefix("venochem")));
    public static final DeferredHolder<EntityType<?>, EntityType<Gokkur>> GOKKUR = ENTITIES.register("gokkur", () -> EntityType.Builder.of(Gokkur::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.2f).notInPeaceful().eyeHeight(0.525f).fireImmune().build(FrostEntities.prefix("gokkur")));
    public static final DeferredHolder<EntityType<?>, EntityType<UnderGokkur>> UNDER_GOKKUR = ENTITIES.register("under_gokkur", () -> EntityType.Builder.of(UnderGokkur::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 1.2f).notInPeaceful().eyeHeight(0.525f).fireImmune().build(FrostEntities.prefix("under_gokkur")));
    public static final DeferredHolder<EntityType<?>, EntityType<RootDeer>> ROOT_DEER = ENTITIES.register("root_deer", () -> EntityType.Builder.of(RootDeer::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 2.375f).notInPeaceful().eyeHeight(0.35f).build(FrostEntities.prefix("root_deer")));
    public static final DeferredHolder<EntityType<?>, EntityType<Seeker>> SEEKER = ENTITIES.register("seeker", () -> EntityType.Builder.of(Seeker::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 5.4f).eyeHeight(5.15f).build(FrostEntities.prefix("seeker")));
    public static final DeferredHolder<EntityType<?>, EntityType<VenomBall>> VENOM_BALL = ENTITIES.register("venom_ball", () -> EntityType.Builder.of(VenomBall::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(8).updateInterval(30).build(FrostEntities.prefix("venom_ball")));
    public static final DeferredHolder<EntityType<?>, EntityType<FlyingBlockEntity>> FLYING_BLOCK = ENTITIES.register("flying_block", () -> EntityType.Builder.of(FlyingBlockEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(10).updateInterval(40).build(FrostEntities.prefix("flying_block")));

    private static ResourceKey<EntityType<?>> prefix(String path) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)FrostRealm.prefix(path));
    }

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put((EntityType)MARMOT.get(), Marmot.createAttributes().build());
        event.put((EntityType)SNOWPILE_QUAIL.get(), SnowPileQuail.createAttributes().build());
        event.put((EntityType)CRYSTAL_FOX.get(), CrystalFox.createAttributes().build());
        event.put((EntityType)SNOW_MOLE.get(), SnowMole.createAttributes().build());
        event.put((EntityType)SEAL.get(), Seal.createAttributes().build());
        event.put((EntityType)WOLFFLUE.get(), Wolfflue.createAttributes().build());
        event.put((EntityType)FERRET.get(), Ferret.createAttributes().build());
        event.put((EntityType)SILK_MOON_WORM.get(), SilkMoonWorm.createAttributes().build());
        event.put((EntityType)SILK_MOON.get(), SilkMoon.createAttributes().build());
        event.put((EntityType)YETI.get(), Yeti.createAttributeMap().build());
        event.put((EntityType)FROST_WRAITH.get(), FrostWraith.createAttributes().build());
        event.put((EntityType)LESSER_WARRIOR.get(), LesserWarrior.createAttributes().build());
        event.put((EntityType)ASTRA_BALL.get(), AstraBall.createAttributes().build());
        event.put((EntityType)FROST_BOAR.get(), FrostBoar.createAttributes().build());
        event.put((EntityType)VENOCHEM.get(), Venochem.createAttributes().build());
        event.put((EntityType)GOKKUR.get(), Gokkur.createAttributes().build());
        event.put((EntityType)UNDER_GOKKUR.get(), UnderGokkur.createAttributes().build());
        event.put((EntityType)ROOT_DEER.get(), RootDeer.createAttributes().build());
        event.put((EntityType)SEEKER.get(), Seeker.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawn(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MARMOT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FrostAnimal::checkFrostAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SNOWPILE_QUAIL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FrostAnimal::checkFrostAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)CRYSTAL_FOX.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FrostAnimal::checkFrostAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SNOW_MOLE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SnowMole::checkSnowMoleSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SEAL.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Seal::checkSealSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)WOLFFLUE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Wolfflue::checkWolfSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)FERRET.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Ferret::checkWolfSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SILK_MOON_WORM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SILK_MOON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SilkMoon::checkSilkSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)YETI.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)FROST_WRAITH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WarpedMonster::checkWarpedMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)LESSER_WARRIOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LesserWarrior::checkStraySpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)ASTRA_BALL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)FROST_BOAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FrostAnimal::checkFrostAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)VENOCHEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Venochem::checkVenochemSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)GOKKUR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)UNDER_GOKKUR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)ROOT_DEER.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RootDeer::checkDeerSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)SEEKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }
}

