/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.utils;

import baguchan.frostrealm.registry.FrostTags;
import baguchi.bagus_lib.util.CombatUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AttackUtils {
    public static void sickleAttack(Player player, Entity target, ItemStack itemstack) {
        if (itemstack.is(FrostTags.Items.SICKLE) && player.onGround()) {
            DamageSource damagesource = Optional.ofNullable(itemstack.getItem().getDamageSource((LivingEntity)player)).orElse(player.damageSources().playerAttack(player));
            float f = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float f2 = player.getAttackStrengthScale(0.5f);
            boolean flag3 = f2 > 0.9f;
            float f7 = (float)(0.5 + player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * 0.5);
            if (flag3) {
                for (LivingEntity livingentity2 : player.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.5, 0.25, 1.5))) {
                    float f3;
                    double entityReachSq = Mth.square((double)(player.entityInteractionRange() + 0.5));
                    if (livingentity2 == player || livingentity2 == target || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq)) continue;
                    f += itemstack.getItem().getAttackDamageBonus((Entity)player, f, damagesource);
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        f3 = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)itemstack, (Entity)livingentity2, (DamageSource)damagesource, (float)f);
                    } else {
                        f3 = f;
                    }
                    float f1 = f3;
                    f += f1;
                    f *= 0.2f + f2 * f2 * 0.8f;
                    livingentity2.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    livingentity2.hurt(damagesource, f *= f7);
                    level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
                    }
                    itemstack.hurtEnemy(livingentity2, (LivingEntity)player);
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                player.sweepAttack();
            }
        }
    }

    public static void damageParticle(Player player, Entity target, float health) {
        if (target instanceof LivingEntity) {
            float f8 = health - ((LivingEntity)target).getHealth();
            if (player.level() instanceof ServerLevel && f8 > 2.0f) {
                int i = (int)((double)f8 * 0.5);
                ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), i, 0.1, 0.0, 0.1, 0.2);
            }
        }
    }

    public static void spearAttack(Player player, Entity target, ItemStack itemstack) {
        if (itemstack.is(FrostTags.Items.SPEAR) && player.onGround()) {
            DamageSource damagesource = Optional.ofNullable(itemstack.getItem().getDamageSource((LivingEntity)player)).orElse(player.damageSources().playerAttack(player));
            float f = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float f2 = player.getAttackStrengthScale(0.5f);
            boolean flag3 = f2 > 0.9f;
            float f7 = f;
            if (flag3) {
                List list = CombatUtils.getTotalEntityHitResult((Level)player.level(), (Entity)player, (Vec3)player.getEyePosition(), (Vec3)player.getEyePosition().add(player.getViewVector(0.0f).scale(player.entityInteractionRange() + 0.5)), (AABB)new AABB(target.blockPosition()).inflate(player.entityInteractionRange() + 1.0), predicate -> predicate != player && predicate != target, (float)0.1f);
                for (Entity entity : list) {
                    float f3;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingentity2 = (LivingEntity)entity;
                    float health = livingentity2.getHealth();
                    double entityReachSq = Mth.square((double)(player.entityInteractionRange() + 0.5));
                    if (livingentity2 == player || livingentity2 == target || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq)) continue;
                    f += itemstack.getItem().getAttackDamageBonus((Entity)player, f, damagesource);
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        f3 = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)itemstack, (Entity)livingentity2, (DamageSource)damagesource, (float)f) - f;
                    } else {
                        f3 = 0.0f;
                    }
                    float f1 = f3;
                    f += f1;
                    f *= 0.2f + f2 * f2 * 0.8f;
                    float f6 = ((float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK) + 0.2f) * 0.5f;
                    livingentity2.knockback((double)f6, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    livingentity2.hurt(damagesource, f /= (float)list.size());
                    Level level2 = player.level();
                    if (level2 instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level2;
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
                    }
                    itemstack.hurtEnemy(livingentity2, (LivingEntity)player);
                    AttackUtils.damageParticle(player, (Entity)livingentity2, health);
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }
}

