/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen;

import baguchan.frostrealm.data.resource.FrostNoises;
import baguchan.frostrealm.registry.FrostBiomes;
import baguchan.frostrealm.registry.FrostBlocks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;

public class FrostChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<FrostChunkGenerator> FROST_CODEC = RecordCodecBuilder.mapCodec(p_255585_ -> p_255585_.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(p_255584_ -> p_255584_.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(p_224278_ -> p_224278_.settings)).apply((Applicative)p_255585_, p_255585_.stable(FrostChunkGenerator::new)));
    protected final BiomeSource biomeSource;
    private final Holder<NoiseGeneratorSettings> settings;
    private final Supplier<Aquifer.FluidPicker> globalFluidPicker;

    public FrostChunkGenerator(BiomeSource p_256415_, Holder<NoiseGeneratorSettings> p_256182_) {
        super(p_256415_, p_256182_);
        this.biomeSource = p_256415_;
        this.settings = p_256182_;
        this.globalFluidPicker = Suppliers.memoize(() -> FrostChunkGenerator.createFluidPicker((NoiseGeneratorSettings)p_256182_.value()));
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return FROST_CODEC;
    }

    private static Aquifer.FluidPicker createFluidPicker(NoiseGeneratorSettings p_249264_) {
        Aquifer.FluidStatus aquifer$fluidstatus = new Aquifer.FluidStatus(-54, Blocks.LAVA.defaultBlockState());
        int i = p_249264_.seaLevel();
        Aquifer.FluidStatus aquifer$fluidstatus1 = new Aquifer.FluidStatus(i, p_249264_.defaultFluid());
        Aquifer.FluidStatus aquifer$fluidstatus2 = new Aquifer.FluidStatus(DimensionType.MIN_Y * 2, Blocks.AIR.defaultBlockState());
        return (p_224274_, p_224275_, p_224276_) -> p_224275_ < Math.min(-54, i) ? aquifer$fluidstatus : aquifer$fluidstatus1;
    }

    private void addIslands(WorldGenRegion primer, ChunkAccess chunk, RandomState randomState, int height) {
        BlockPos blockpos = primer.getCenter().getWorldPosition();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        boolean stony_islands = false;
        for (int dZ = 0; dZ < 5; ++dZ) {
            for (int dX = 0; dX < 5; ++dX) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        BlockPos p = blockpos.offset(dX + bx << 2, 0, dZ + bz << 2);
                        Biome biome = (Biome)this.biomeSource.getNoiseBiome(p.getX() >> 2, 256, p.getZ() >> 2, randomState.sampler()).value();
                        if (!FrostBiomes.CRYSTAL_FALL.location().equals((Object)primer.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome))) continue;
                        int n = dX + dZ * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                        stony_islands = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return;
        }
        double d = 0.03125;
        for (int dZ = 0; dZ < 16; ++dZ) {
            for (int dX = 0; dX < 16; ++dX) {
                int qx = dX >> 2;
                int qz = dZ >> 2;
                float xweight = (float)(dX % 4) * 0.25f + 0.125f;
                float zweight = (float)(dZ % 4) * 0.25f + 0.125f;
                float thickness = (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight) + (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight) + (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight + (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight - 4.0f;
                if (!(thickness > 1.0f)) continue;
                int dY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE_WG, dX, dZ);
                int oceanFloor = chunk.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, dX, dZ);
                BlockPos pos = primer.getCenter().getWorldPosition().offset(dX, dY, dZ);
                int noise = (int)(randomState.getOrCreateNoise(FrostNoises.ISLANDS_BOTTOM_HEIGHT).getValue((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) * 64.0);
                int noise2 = (int)(randomState.getOrCreateNoise(FrostNoises.ISLANDS_HEIGHT).getValue((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) * 24.0);
                int islandsBottom = pos.getY() + height - (int)(thickness * 0.5f);
                int islandsTop = islandsBottom + (int)(thickness * 1.5f);
                islandsBottom -= noise;
                islandsTop -= noise2;
                BlockState baseBlock = ((Block)FrostBlocks.FRIGID_STONE.get()).defaultBlockState();
                FrostChunkGenerator.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE_WG, pos, dY);
                FrostChunkGenerator.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE, pos, dY);
                FrostChunkGenerator.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR_WG, pos, oceanFloor);
                FrostChunkGenerator.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR, pos, oceanFloor);
                for (int y = islandsBottom; y < islandsTop; ++y) {
                    primer.setBlock(pos.atY(y), baseBlock, 3);
                }
            }
        }
    }

    public void buildSurface(WorldGenRegion p_224232_, StructureManager p_224233_, RandomState p_224234_, ChunkAccess p_224235_) {
        if (!SharedConstants.debugVoidTerrain((ChunkPos)p_224235_.getPos())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)p_224232_);
            this.buildSurface(p_224232_, p_224235_, worldgenerationcontext, p_224234_, p_224233_, p_224232_.getBiomeManager(), (Registry<Biome>)p_224232_.registryAccess().lookupOrThrow(Registries.BIOME), Blender.of((WorldGenRegion)p_224232_));
        }
    }

    @VisibleForTesting
    public void buildSurface(WorldGenRegion worldGenRegion, ChunkAccess p_224262_, WorldGenerationContext p_224263_, RandomState p_224264_, StructureManager p_224265_, BiomeManager p_224266_, Registry<Biome> p_224267_, Blender p_224268_) {
        NoiseChunk noisechunk = p_224262_.getOrCreateNoiseChunk(p_224321_ -> this.createNoiseChunk((ChunkAccess)p_224321_, p_224265_, p_224268_, p_224264_));
        NoiseGeneratorSettings noisegeneratorsettings = (NoiseGeneratorSettings)this.settings.value();
        this.addIslands(worldGenRegion, p_224262_, p_224264_, 64);
        p_224264_.surfaceSystem().buildSurface(p_224264_, p_224266_, p_224267_, noisegeneratorsettings.useLegacyRandomSource(), p_224263_, p_224262_, noisechunk, noisegeneratorsettings.surfaceRule());
    }

    private NoiseChunk createNoiseChunk(ChunkAccess p_224257_, StructureManager p_224258_, Blender p_224259_, RandomState p_224260_) {
        return NoiseChunk.forChunk((ChunkAccess)p_224257_, (RandomState)p_224260_, (DensityFunctions.BeardifierOrMarker)Beardifier.forStructuresInChunk((StructureManager)p_224258_, (ChunkPos)p_224257_.getPos()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.value()), (Aquifer.FluidPicker)this.globalFluidPicker.get(), (Blender)p_224259_);
    }

    static void forceHeightMapLevel(ChunkAccess chunk, Heightmap.Types type, BlockPos pos, int dY) {
        chunk.getOrCreateHeightmapUnprimed(type).setHeight(pos.getX() & 0xF, pos.getZ() & 0xF, dY + 1);
    }
}

