/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.world.trunk.DripWoodTrunkPlacer;
import java.util.OptionalInt;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class FrostTreeFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROST_TREE = FrostTreeFeatures.registerKey("frostroot_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROST_TREE_BIG = FrostTreeFeatures.registerKey("frostroot_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTBITE_TREE = FrostTreeFeatures.registerKey("frostbite_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROSTBITE_TREE_BIG = FrostTreeFeatures.registerKey("frostbite_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRIP_WOOD_TREE = FrostTreeFeatures.registerKey("drip_wood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRIP_WOOD_TREE_BIG = FrostTreeFeatures.registerKey("drip_wood_tree_big");

    public static String prefix(String name) {
        return "frostrealm:" + name;
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)FrostRealm.prefix(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, FROST_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createFrostRoot().build());
        FeatureUtils.register(context, FROST_TREE_BIG, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createFancyFrostRoot().build());
        FeatureUtils.register(context, FROSTBITE_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createFrostBite().build());
        FeatureUtils.register(context, FROSTBITE_TREE_BIG, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createFancyFrostBite().build());
        FeatureUtils.register(context, DRIP_WOOD_TREE, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createDripWood().build());
        FeatureUtils.register(context, DRIP_WOOD_TREE_BIG, (Feature)Feature.TREE, (FeatureConfiguration)FrostTreeFeatures.createDripWoodBig().build());
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block p_195147_, Block p_195148_, int p_195149_, int p_195150_, int p_195151_, int p_195152_) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)p_195147_), (TrunkPlacer)new StraightTrunkPlacer(p_195149_, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.simple((Block)p_195148_), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)p_195152_), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFrostRoot() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTROOT_LOG.get())), (TrunkPlacer)new FancyTrunkPlacer(3, 3, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTROOT_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyFrostRoot() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTROOT_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(4, 11, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTROOT_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)2), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createDripWoodBig() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.DRIP_LOG.get())), (TrunkPlacer)new DripWoodTrunkPlacer(32, 8, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.DRIP_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createDripWood() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.DRIP_LOG.get())), (TrunkPlacer)new DripWoodTrunkPlacer(8, 8, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.DRIP_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFrostBite() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTBITE_LOG.get())), (TrunkPlacer)new ForkingTrunkPlacer(8, 4, 0), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTBITE_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyFrostBite() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTBITE_LOG.get())), (TrunkPlacer)new CherryTrunkPlacer(10, 6, 0, (IntProvider)new WeightedListInt(WeightedList.builder().add((Object)ConstantInt.of((int)1), 1).add((Object)ConstantInt.of((int)2), 1).add((Object)ConstantInt.of((int)3), 1).build()), (IntProvider)UniformInt.of((int)2, (int)4), UniformInt.of((int)-4, (int)-3), (IntProvider)UniformInt.of((int)-1, (int)0)), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROSTBITE_LEAVES.get())), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new ThreeLayersFeatureSize(1, 1, 0, 1, 2, OptionalInt.empty())).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)FrostBlocks.FROZEN_DIRT.get())));
    }
}

