/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen.feature;

import baguchan.frostrealm.utils.BlockPlaceUtils;
import baguchan.frostrealm.world.gen.feature.config.FloatingRockConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class FloatingRockFeature
extends Feature<FloatingRockConfiguration> {
    public FloatingRockFeature(Codec<FloatingRockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FloatingRockConfiguration> config) {
        BlockPos pos = config.origin();
        WorldGenLevel level = config.level();
        RandomSource random = config.random();
        float radius = ((FloatingRockConfiguration)config.config()).baseRadius().sample(random);
        float addtionalRadius = ((FloatingRockConfiguration)config.config()).additionalRadius().sample(random);
        float height = radius + addtionalRadius;
        int offset = (int)(-radius * 20.0f + radius * 16.0f);
        float lake_edge = Math.min(radius - 2.0f, radius - (float)random.nextInt((int)(radius - 4.0f)));
        float range = 0.0f;
        for (int i = offset; i < 0; ++i) {
            BlockPlaceUtils.placeDisk(level, ((FloatingRockConfiguration)config.config()).block(), new BlockPos(pos.getX(), (int)((float)(pos.getY() + i) + height + (float)((int)radius)), pos.getZ()), radius + (float)i, random, true);
            BlockPlaceUtils.placeDisk(level, (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.WATER.defaultBlockState()), new BlockPos(pos.getX(), (int)((float)(pos.getY() + i) + height + radius), pos.getZ()), lake_edge + (float)i, random, true);
            radius += 0.25f * random.nextFloat();
            lake_edge += 0.15f * random.nextFloat();
        }
        return true;
    }
}

