/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen.feature;

import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.world.gen.feature.config.HeightBlockStateConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SmallVolcanoFeature
extends Feature<HeightBlockStateConfiguration> {
    public SmallVolcanoFeature(Codec<HeightBlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<HeightBlockStateConfiguration> blockstateconfiguration) {
        BlockPos blockpos = blockstateconfiguration.origin().below(3);
        WorldGenLevel worldgenlevel = blockstateconfiguration.level();
        RandomSource random = blockstateconfiguration.random();
        if (worldgenlevel.getBlockState(blockpos).is(BlockTags.FEATURES_CANNOT_REPLACE)) {
            return false;
        }
        int height = ((HeightBlockStateConfiguration)blockstateconfiguration.config()).baseHeight().sample(random);
        int width = (int)((float)height / 2.0f);
        for (int y = -height; y < height; ++y) {
            BlockPos spikePos = blockpos.above(y);
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)spikePos.offset(-width, 0, -width), (BlockPos)spikePos.offset(width, 0, width))) {
                if (!(blockpos.below(y).distSqr((Vec3i)blockpos1) > (double)width) || !(blockpos.distSqr((Vec3i)blockpos1) < (double)(width * width + height)) || worldgenlevel.getBlockState(blockpos1).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                if (blockpos.above(y).distSqr((Vec3i)blockpos1) >= (double)width) {
                    worldgenlevel.setBlock(blockpos1, ((HeightBlockStateConfiguration)blockstateconfiguration.config()).block().getState(random, blockpos1), 2);
                    continue;
                }
                if (y < 1) continue;
                worldgenlevel.setBlock(blockpos1, Blocks.LAVA.defaultBlockState(), 2);
            }
        }
        worldgenlevel.setBlock(blockpos.above(), ((Block)FrostBlocks.MAGMA_CORE.get()).defaultBlockState(), 2);
        return true;
    }
}

