/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.world.gen.feature;

import baguchan.frostrealm.registry.FrostBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StoneSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public StoneSpikeFeature(Codec<NoneFeatureConfiguration> p_66003_) {
        super(p_66003_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159882_) {
        BlockPos blockpos = p_159882_.origin();
        RandomSource randomsource = p_159882_.random();
        WorldGenLevel worldgenlevel = p_159882_.level();
        while (worldgenlevel.isEmptyBlock(blockpos) && blockpos.getY() > worldgenlevel.getMinY() + 2) {
            blockpos = blockpos.below();
        }
        if (!worldgenlevel.getBlockState(blockpos).is((Block)FrostBlocks.FRIGID_GRASS_BLOCK.get())) {
            return false;
        }
        blockpos = blockpos.above(randomsource.nextInt(4));
        int i = randomsource.nextInt(4) + 7;
        int j = i / 4 + randomsource.nextInt(2);
        if (j > 1 && randomsource.nextInt(60) == 0) {
            blockpos = blockpos.above(10 + randomsource.nextInt(30));
        }
        for (int k = 0; k < i; ++k) {
            float f = (1.0f - (float)k / (float)i) * (float)j;
            int l = Mth.ceil((float)f);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.abs((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.abs((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && randomsource.nextFloat() > 0.75f) continue;
                    BlockState blockstate = worldgenlevel.getBlockState(blockpos.offset(i1, k, j1));
                    if (blockstate.isAir() || StoneSpikeFeature.isDirt((BlockState)blockstate) || blockstate.is(Blocks.SNOW_BLOCK) || blockstate.is((Block)FrostBlocks.FRIGID_GRASS_BLOCK.get())) {
                        this.setBlock((LevelWriter)worldgenlevel, blockpos.offset(i1, k, j1), ((Block)FrostBlocks.FRIGID_STONE_MOSSY.get()).defaultBlockState());
                    }
                    if (k == 0 || l <= 1 || !(blockstate = worldgenlevel.getBlockState(blockpos.offset(i1, -k, j1))).isAir() && !StoneSpikeFeature.isDirt((BlockState)blockstate) && !blockstate.is(Blocks.SNOW_BLOCK) && !blockstate.is((Block)FrostBlocks.FRIGID_GRASS_BLOCK.get())) continue;
                    this.setBlock((LevelWriter)worldgenlevel, blockpos.offset(i1, -k, j1), ((Block)FrostBlocks.FRIGID_STONE_MOSSY.get()).defaultBlockState());
                }
            }
        }
        int k1 = j - 1;
        if (k1 < 0) {
            k1 = 0;
        } else if (k1 > 1) {
            k1 = 1;
        }
        for (int l1 = -k1; l1 <= k1; ++l1) {
            for (int i2 = -k1; i2 <= k1; ++i2) {
                BlockState blockstate1;
                BlockPos blockpos1 = blockpos.offset(l1, -1, i2);
                int j2 = 50;
                if (Math.abs(l1) == 1 && Math.abs(i2) == 1) {
                    j2 = randomsource.nextInt(5);
                }
                while (blockpos1.getY() > 50 && ((blockstate1 = worldgenlevel.getBlockState(blockpos1)).isAir() || StoneSpikeFeature.isDirt((BlockState)blockstate1) || blockstate1.is(Blocks.SNOW_BLOCK) || blockstate1.is(Blocks.ICE) || blockstate1.is(Blocks.PACKED_ICE))) {
                    this.setBlock((LevelWriter)worldgenlevel, blockpos1, ((Block)FrostBlocks.FRIGID_STONE_MOSSY.get()).defaultBlockState());
                    blockpos1 = blockpos1.below();
                    if (--j2 > 0) continue;
                    blockpos1 = blockpos1.below(randomsource.nextInt(5) + 1);
                    j2 = randomsource.nextInt(5);
                }
            }
        }
        return true;
    }
}

