/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FrostCampfireBlock
extends CampfireBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public FrostCampfireBlock(BlockBehaviour.Properties p_49795_) {
        super(false, 2, p_49795_);
    }

    protected void entityInside(BlockState p_60495_, Level p_60496_, BlockPos p_60497_, Entity p_60498_, InsideBlockEffectApplier p_405359_, boolean p_451772_) {
        if (((Boolean)p_60495_.getValue((Property)LIT)).booleanValue() && p_60498_ instanceof LivingEntity) {
            p_60498_.hurt(p_60498_.damageSources().freeze(), 2.0f);
        }
    }

    public VoxelShape getShape(BlockState p_51309_, BlockGetter p_51310_, BlockPos p_51311_, CollisionContext p_51312_) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState p_51307_) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState p_220918_, Level p_220919_, BlockPos p_220920_, RandomSource p_220921_) {
        if (((Boolean)p_220918_.getValue((Property)LIT)).booleanValue() && p_220921_.nextInt(10) == 0) {
            p_220919_.playLocalSound((double)p_220920_.getX() + 0.5, (double)p_220920_.getY() + 0.5, (double)p_220920_.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + p_220921_.nextFloat(), p_220921_.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    public void onProjectileHit(Level p_51244_, BlockState p_51245_, BlockHitResult p_51246_, Projectile p_51247_) {
        BlockPos blockpos = p_51246_.getBlockPos();
        if (p_51244_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)p_51244_;
            if (!p_51244_.isClientSide() && p_51247_.isOnFire() && p_51247_.mayInteract(serverLevel, blockpos) && !((Boolean)p_51245_.getValue((Property)LIT)).booleanValue() && !((Boolean)p_51245_.getValue((Property)WATERLOGGED)).booleanValue()) {
                p_51244_.setBlock(blockpos, (BlockState)p_51245_.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DANGER_OTHER;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }
}

