/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.world.placement.FrostPlacements;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;

public class FrostGrassBlock
extends SpreadingSnowyDirtBlock
implements BonemealableBlock {
    public final Supplier<Block> turnBlock;

    public FrostGrassBlock(BlockBehaviour.Properties p_53685_, Supplier<Block> turnBlock) {
        super(p_53685_);
        this.turnBlock = turnBlock;
    }

    public boolean isValidBonemealTarget(LevelReader p_53692_, BlockPos p_53693_, BlockState p_53694_) {
        return p_53692_.getBlockState(p_53693_.above()).isAir();
    }

    public boolean isBonemealSuccess(Level p_53697_, RandomSource p_53698_, BlockPos p_53699_, BlockState p_53700_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_221270_, RandomSource p_221271_, BlockPos p_221272_, BlockState p_221273_) {
        BlockPos blockpos = p_221272_.above();
        BlockState blockstate = ((Block)FrostBlocks.COLD_GRASS.get()).defaultBlockState();
        Optional optional = p_221270_.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE).get(FrostPlacements.PATCH_TUNDRA_GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!p_221270_.getBlockState((blockpos1 = blockpos1.offset(p_221271_.nextInt(3) - 1, (p_221271_.nextInt(3) - 1) * p_221271_.nextInt(3) / 2, p_221271_.nextInt(3) - 1)).below()).is((Block)this) || p_221270_.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)p_221270_, blockpos1)) continue block0;
            }
            BlockState blockstate1 = p_221270_.getBlockState(blockpos1);
            if (blockstate1.is(blockstate.getBlock()) && p_221271_.nextInt(10) == 0) {
                ((BonemealableBlock)blockstate.getBlock()).performBonemeal(p_221270_, p_221271_, blockpos1, blockstate1);
            }
            if (!blockstate1.isAir()) continue;
            if (p_221271_.nextInt(8) == 0) {
                List list = ((Biome)p_221270_.getBiome(blockpos1).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).config()).feature();
            } else {
                if (!optional.isPresent()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.value()).place((WorldGenLevel)p_221270_, p_221270_.getChunkSource().getGenerator(), p_221271_, blockpos1);
        }
    }

    public void randomTick(BlockState p_56819_, ServerLevel p_56820_, BlockPos p_56821_, RandomSource p_56822_) {
        if (!FrostGrassBlock.canBeGrass(p_56819_, (LevelReader)p_56820_, p_56821_)) {
            if (!p_56820_.isAreaLoaded(p_56821_, 3)) {
                return;
            }
            p_56820_.setBlockAndUpdate(p_56821_, this.turnBlock.get().defaultBlockState());
        } else if (p_56820_.getMaxLocalRawBrightness(p_56821_.above()) >= 9) {
            BlockState blockstate = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = p_56821_.offset(p_56822_.nextInt(3) - 1, p_56822_.nextInt(5) - 3, p_56822_.nextInt(3) - 1);
                if (!p_56820_.getBlockState(blockpos).is(this.turnBlock.get()) || !FrostGrassBlock.canPropagate(blockstate, (LevelReader)p_56820_, blockpos)) continue;
                p_56820_.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(p_56820_.getBlockState(blockpos.above()).is(Blocks.SNOW))));
            }
        }
    }

    private static boolean canBeGrass(BlockState p_56824_, LevelReader p_56825_, BlockPos p_56826_) {
        BlockPos blockpos = p_56826_.above();
        BlockState blockstate = p_56825_.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) <= 3) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockState)p_56824_, (BlockState)blockstate, (Direction)Direction.UP, (int)blockstate.getLightBlock());
        return i < 15;
    }

    protected MapCodec<? extends SpreadingSnowyDirtBlock> codec() {
        return null;
    }

    private static boolean canPropagate(BlockState p_56828_, LevelReader p_56829_, BlockPos p_56830_) {
        BlockPos blockpos = p_56830_.above();
        return FrostGrassBlock.canBeGrass(p_56828_, p_56829_, p_56830_) && !p_56829_.getFluidState(blockpos).is(FluidTags.WATER);
    }
}

