/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.registry.FrostBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;

public class FrozenFarmBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public FrozenFarmBlock(BlockBehaviour.Properties p_53247_) {
        super(p_53247_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockState updateShape(BlockState p_60541_, LevelReader p_374332_, ScheduledTickAccess p_374457_, BlockPos p_60545_, Direction p_60542_, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        if (p_60542_ == Direction.UP && !p_60541_.canSurvive(p_374332_, p_60545_)) {
            p_374457_.scheduleTick(p_60545_, (Block)this, 1);
        }
        return super.updateShape(p_60541_, p_374332_, p_374457_, p_60545_, p_60542_, p_60546_, p_60543_, p_374120_);
    }

    public boolean canSurvive(BlockState p_53272_, LevelReader p_53273_, BlockPos p_53274_) {
        BlockState blockstate = p_53273_.getBlockState(p_53274_.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_53249_) {
        return !this.defaultBlockState().canSurvive((LevelReader)p_53249_.getLevel(), p_53249_.getClickedPos()) ? ((Block)FrostBlocks.FROZEN_DIRT.get()).defaultBlockState() : super.getStateForPlacement(p_53249_);
    }

    public boolean useShapeForLightOcclusion(BlockState p_53295_) {
        return true;
    }

    public VoxelShape getShape(BlockState p_53290_, BlockGetter p_53291_, BlockPos p_53292_, CollisionContext p_53293_) {
        return SHAPE;
    }

    public void tick(BlockState p_53262_, ServerLevel p_53263_, BlockPos p_53264_, RandomSource p_53265_) {
        if (!p_53262_.canSurvive((LevelReader)p_53263_, p_53264_)) {
            FrozenFarmBlock.turnToDirt(p_53262_, (Level)p_53263_, p_53264_);
        }
    }

    public void randomTick(BlockState p_53285_, ServerLevel p_53286_, BlockPos p_53287_, RandomSource p_53288_) {
        int i = (Integer)p_53285_.getValue((Property)MOISTURE);
        if (!FrozenFarmBlock.isNearWater((LevelReader)p_53286_, p_53287_) && !p_53286_.isRainingAt(p_53287_.above())) {
            if (i > 0) {
                p_53286_.setBlock(p_53287_, (BlockState)p_53285_.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!FrozenFarmBlock.shouldMaintainFarmland((BlockGetter)p_53286_, p_53287_)) {
                FrozenFarmBlock.turnToDirt(p_53285_, (Level)p_53286_, p_53287_);
            }
        } else if (i < 7) {
            p_53286_.setBlock(p_53287_, (BlockState)p_53285_.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_397222_) {
        ServerLevel serverLevel;
        if (p_152426_ instanceof ServerLevel && CommonHooks.onFarmlandTrample((ServerLevel)(serverLevel = (ServerLevel)p_152426_), (BlockPos)p_152428_, (BlockState)((Block)FrostBlocks.FROZEN_DIRT.get()).defaultBlockState(), (double)p_397222_, (Entity)p_152429_)) {
            FrozenFarmBlock.turnToDirt(p_152427_, p_152426_, p_152428_);
        }
        super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_397222_);
    }

    public static void turnToDirt(BlockState p_53297_, Level p_53298_, BlockPos p_53299_) {
        p_53298_.setBlockAndUpdate(p_53299_, FrozenFarmBlock.pushEntitiesUp((BlockState)p_53297_, (BlockState)((Block)FrostBlocks.FROZEN_DIRT.get()).defaultBlockState(), (LevelAccessor)p_53298_, (BlockPos)p_53299_));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        return p_279219_.getBlockState(p_279209_.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(LevelReader p_53259_, BlockPos p_53260_) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)p_53260_.offset(-4, 0, -4), (BlockPos)p_53260_.offset(4, 1, 4))) {
            if (!p_53259_.getFluidState(blockpos).is(FluidTags.WATER)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)p_53259_, (BlockPos)p_53260_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_53283_) {
        p_53283_.add(new Property[]{MOISTURE});
    }

    protected boolean isPathfindable(BlockState p_60475_, PathComputationType p_60478_) {
        return false;
    }
}

