/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block.crop;

import baguchan.frostrealm.registry.FrostItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class BearBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public BearBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockGetter p_57256_, BlockPos p_57257_, BlockState p_57258_) {
        return new ItemStack((ItemLike)FrostItems.BEARBERRY.get());
    }

    public VoxelShape getShape(BlockState p_57291_, BlockGetter p_57292_, BlockPos p_57293_, CollisionContext p_57294_) {
        return SHAPE;
    }

    public boolean isRandomlyTicking(BlockState p_57284_) {
        return (Integer)p_57284_.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void entityInside(BlockState p_60495_, Level p_60496_, BlockPos p_60497_, Entity p_60498_, InsideBlockEffectApplier p_405359_, boolean p_451772_) {
        if (p_60498_ instanceof LivingEntity && p_60498_.getType() != EntityType.FOX && p_60498_.getType() != EntityType.BEE) {
            p_60498_.makeStuckInBlock(p_60495_, new Vec3((double)0.8f, 0.75, (double)0.8f));
        }
    }

    protected InteractionResult useItemOn(ItemStack p_316304_, BlockState p_57275_, Level p_57276_, BlockPos p_57277_, Player p_57278_, InteractionHand p_57279_, BlockHitResult p_57280_) {
        boolean flag;
        int i = (Integer)p_57275_.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && p_57278_.getItemInHand(p_57279_).is(Items.BONE_MEAL)) {
            return InteractionResult.SUCCESS;
        }
        if (i > 2) {
            int j = 1 + p_57276_.random.nextInt(2);
            BearBerryBushBlock.popResource((Level)p_57276_, (BlockPos)p_57277_, (ItemStack)new ItemStack((ItemLike)FrostItems.BEARBERRY.get(), j));
            p_57276_.playSound(null, p_57277_, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + p_57276_.random.nextFloat() * 0.4f);
            p_57276_.setBlock(p_57277_, (BlockState)p_57275_.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useItemOn(p_316304_, p_57275_, p_57276_, p_57277_, p_57278_, p_57279_, p_57280_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader p_57260_, BlockPos p_57261_, BlockState p_57262_) {
        return (Integer)p_57262_.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level p_57265_, RandomSource p_57266_, BlockPos p_57267_, BlockState p_57268_) {
        return true;
    }

    public void performBonemeal(ServerLevel p_57251_, RandomSource p_57252_, BlockPos p_57253_, BlockState p_57254_) {
        int i = Math.min(3, (Integer)p_57254_.getValue((Property)AGE) + 1);
        p_57251_.setBlock(p_57253_, (BlockState)p_57254_.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

