/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client;

import baguchan.frostrealm.api.recipe.AttachableCrystal;
import baguchan.frostrealm.client.ClientRegistrar;
import baguchan.frostrealm.client.animation.SpearAttackAnimations;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.data.resource.registries.AttachableCrystals;
import baguchan.frostrealm.registry.FrostAnimations;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.sounds.MusicInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="frostrealm", value={Dist.CLIENT})
public class ClientEvents {
    public static final Music CALM_NIGHT = ClientEvents.createFrostMusic(FrostSounds.CALM_NIGHT_BGM);
    public static final Music FROST_MOON = ClientEvents.createFrostMusic(FrostSounds.FROST_MOON_BGM);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void clientAnimation(BagusModelEvent.PostAnimate event) {
        LivingEntityRenderState livingEntityRenderState = event.getEntityRenderState();
        if (livingEntityRenderState instanceof HumanoidRenderState) {
            boolean flag;
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)livingEntityRenderState;
            boolean bl = flag = humanoidRenderState.mainArm == HumanoidArm.RIGHT;
            if (event.getEntityRenderState().getRenderData(ClientRegistrar.HOLD_SPEAR_KEY) != null && ((Boolean)event.getEntityRenderState().getRenderData(ClientRegistrar.HOLD_SPEAR_KEY)).booleanValue()) {
                event.getModel().root().getChild("right_arm").resetPose();
                event.getModel().root().getChild("left_arm").resetPose();
                if (!event.getBaguAnimationController().getAnimationState(FrostAnimations.SPEAR_ATTACK).isStarted()) {
                    if (flag) {
                        SpearAttackAnimations.spear_attack_right.bake(event.getModel().root()).applyStatic();
                    } else {
                        SpearAttackAnimations.spear_attack_left.bake(event.getModel().root()).applyStatic();
                    }
                }
                if (flag) {
                    SpearAttackAnimations.spear_attack_right.bake(event.getModel().root()).apply(event.getBaguAnimationController().getAnimationState(FrostAnimations.SPEAR_ATTACK), event.getEntityRenderState().ageInTicks);
                } else {
                    SpearAttackAnimations.spear_attack_left.bake(event.getModel().root()).apply(event.getBaguAnimationController().getAnimationState(FrostAnimations.SPEAR_ATTACK), event.getEntityRenderState().ageInTicks);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        AuroraPowerUtils.getAuroraPowers(event.getItemStack()).addToTooltip(event.getContext(), component -> event.getToolTip().add(component), (TooltipFlag)TooltipFlag.NORMAL, (DataComponentGetter)event.getItemStack());
        @Nullable Holder attachableCrystal = (Holder)event.getItemStack().get(FrostDataCompnents.ATTACH_CRYSTAL);
        int damage = (Integer)event.getItemStack().getOrDefault(FrostDataCompnents.CRYSTAL_USED, (Object)0);
        if (attachableCrystal != null) {
            int damage2 = ((AttachableCrystal)attachableCrystal.value()).getUse() - damage;
            if (event.getItemStack().getItem() instanceof ArrowItem || event.getItemStack().is(FrostItems.COATING_FUR)) {
                event.getToolTip().add(Component.translatable((String)Util.makeDescriptionId((String)"attach_crystal", (ResourceLocation)((HolderLookup.RegistryLookup)event.getContext().registries().lookup(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY).get()).getOrThrow(attachableCrystal.getKey()).getKey().location())));
            } else {
                event.getToolTip().add(Component.translatable((String)Util.makeDescriptionId((String)"attach_crystal", (ResourceLocation)((HolderLookup.RegistryLookup)event.getContext().registries().lookup(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY).get()).getOrThrow(attachableCrystal.getKey()).getKey().location())).append(" ").append(damage2 + " / " + ((AttachableCrystal)attachableCrystal.value()).getUse()));
            }
        }
    }

    @SubscribeEvent
    public static void onMusicPlayed(SelectMusicEvent event) {
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            Holder biome = Minecraft.getInstance().player.level().getBiome(Minecraft.getInstance().player.blockPosition());
            float volume = ((Biome)biome.value()).getBackgroundMusicVolume();
            if (Minecraft.getInstance().level.dimension() == FrostDimensions.FROSTREALM_LEVEL) {
                Optional musicInfo = ((Biome)biome.value()).getBackgroundMusic();
                if (!(Minecraft.getInstance().screen instanceof WinScreen)) {
                    boolean sunrise;
                    long time = Minecraft.getInstance().player.level().getLevelData().getDayTime() % 24000L;
                    boolean day = time >= 0L && time < 12000L;
                    boolean sunset = time >= 12000L && time < 14000L;
                    boolean night = time >= 14000L && time < 22000L;
                    boolean bl = sunrise = time >= 22000L;
                    if (night) {
                        event.setMusic(new MusicInfo(CALM_NIGHT, volume));
                    } else {
                        event.setMusic(new MusicInfo(FROST_MOON, volume));
                    }
                }
            }
        }
    }

    public static Music createFrostMusic(Holder<SoundEvent> event) {
        return new Music(event, 3600, 10800, false);
    }
}

