/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.CrystalFoxAnimations;
import baguchan.frostrealm.client.render.state.CrystalFoxRenderState;
import baguchan.frostrealm.entity.animal.CrystalFox;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CrystalFoxModel<T extends CrystalFoxRenderState>
extends EntityModel<T> {
    public final ModelPart main;
    public final ModelPart body;
    public final ModelPart head;
    private final ModelPart tail;
    private final ModelPart leg_left_front;
    private final ModelPart leg_left_hind;
    private final ModelPart leg_right_front;
    private final ModelPart leg_right_hind;
    private final KeyframeAnimation eatAnimationState;
    private final KeyframeAnimation sitAnimationState;
    private final KeyframeAnimation sleepAnimationState;

    public CrystalFoxModel(ModelPart root) {
        super(root);
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.head = this.body.getChild("head");
        this.tail = this.body.getChild("tail");
        this.leg_left_front = this.body.getChild("leg_left_front");
        this.leg_left_hind = this.body.getChild("leg_left_hind");
        this.leg_right_front = this.body.getChild("leg_right_front");
        this.leg_right_hind = this.body.getChild("leg_right_hind");
        this.eatAnimationState = CrystalFoxAnimations.CRYSTAL_FOX_EATING.bake(root);
        this.sitAnimationState = CrystalFoxAnimations.sit.bake(root);
        this.sleepAnimationState = CrystalFoxAnimations.sleep.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-6.4f));
        PartDefinition body = main.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(50, 19).addBox(-1.0f, -8.0f, 2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(33, 23).addBox(-1.0f, -7.0f, 6.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-2.0f, 1.0f, -9.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(-3.0f, -6.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(1.0f, -6.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(36, 14).addBox(2.0f, -1.0f, 4.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 14).addBox(-3.0f, -1.0f, 4.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 14).addBox(-1.0f, -3.0f, 1.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 14).addBox(-1.0f, 3.0f, 2.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)11.0f));
        PartDefinition leg_left_front = body.addOrReplaceChild("leg_left_front", CubeListBuilder.create().texOffs(28, 17).addBox(-0.999f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 23).addBox(-0.5f, 3.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.0f, (float)3.0f));
        PartDefinition leg_left_hind = body.addOrReplaceChild("leg_left_hind", CubeListBuilder.create().texOffs(28, 17).addBox(-0.999f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 23).addBox(-0.5f, 3.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.0f, (float)10.0f));
        PartDefinition leg_right_front = body.addOrReplaceChild("leg_right_front", CubeListBuilder.create().texOffs(28, 17).addBox(-0.001f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 23).addBox(0.999f, 3.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-2.0f, (float)3.0f));
        PartDefinition leg_right_hind = body.addOrReplaceChild("leg_right_hind", CubeListBuilder.create().texOffs(28, 17).addBox(-0.001f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 23).addBox(0.999f, 3.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-2.0f, (float)10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        if (((CrystalFoxRenderState)((Object)entity)).state == CrystalFox.State.IDLING || ((CrystalFoxRenderState)((Object)entity)).state == CrystalFox.State.SITTING) {
            this.head.yRot = ((CrystalFoxRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
            this.head.xRot = ((CrystalFoxRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        }
        if (((CrystalFoxRenderState)((Object)entity)).state == CrystalFox.State.IDLING) {
            this.leg_right_hind.xRot = Mth.cos((float)(((CrystalFoxRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 1.4f * ((CrystalFoxRenderState)((Object)entity)).walkAnimationSpeed;
            this.leg_left_hind.xRot = Mth.cos((float)(((CrystalFoxRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((CrystalFoxRenderState)((Object)entity)).walkAnimationSpeed;
            this.leg_right_front.xRot = Mth.cos((float)(((CrystalFoxRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((CrystalFoxRenderState)((Object)entity)).walkAnimationSpeed;
            this.leg_left_front.xRot = Mth.cos((float)(((CrystalFoxRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 1.4f * ((CrystalFoxRenderState)((Object)entity)).walkAnimationSpeed;
        }
        this.eatAnimationState.apply(((CrystalFoxRenderState)((Object)entity)).eatAnimationState, ((CrystalFoxRenderState)((Object)entity)).ageInTicks);
        if (((CrystalFoxRenderState)((Object)entity)).state == CrystalFox.State.SITTING) {
            this.sitAnimationState.applyStatic();
        }
        if (((CrystalFoxRenderState)((Object)entity)).state == CrystalFox.State.SLEEPING) {
            this.sleepAnimationState.applyStatic();
        }
    }
}

