/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.SealAnimations;
import baguchan.frostrealm.client.render.state.SealRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SealModel<T extends SealRenderState>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final KeyframeAnimation babyAnimationState;
    private final KeyframeAnimation swimAnimationState;
    private final KeyframeAnimation walkAnimationState;

    public SealModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("body").getChild("head");
        this.babyAnimationState = SealAnimations.BABY.bake(root);
        this.swimAnimationState = SealAnimations.SWIM.bake(root);
        this.walkAnimationState = SealAnimations.WALK.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 0).addBox(-5.0f, -8.0f, -5.0f, 10.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-6.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(60, 0).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)10.0f));
        PartDefinition tail = body2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(92, 0).addBox(-3.0f, -1.0f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(112, 0).mirror().addBox(1.0f, 3.0f, 6.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(112, 0).addBox(-5.0f, 3.0f, 6.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-4.25f));
        PartDefinition right_hand = body.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(0, 24).addBox(-8.0f, -1.0f, -2.0f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition right_hand2 = right_hand.addOrReplaceChild("right_hand2", CubeListBuilder.create().texOffs(0, 31).addBox(-6.0f, -1.0f, 0.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition left_hand = body.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-1.0f, -1.0f, -2.0f, 9.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition left_hand2 = left_hand.addOrReplaceChild("left_hand2", CubeListBuilder.create().texOffs(0, 31).mirror().addBox(0.0f, -1.0f, 0.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)7.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((SealRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((SealRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        if (((SealRenderState)((Object)entity)).isBaby) {
            this.babyAnimationState.applyStatic();
        }
        if (((SealRenderState)((Object)entity)).isInWater) {
            this.swimAnimationState.applyWalk(((SealRenderState)((Object)entity)).walkAnimationPos, ((SealRenderState)((Object)entity)).walkAnimationSpeed, 1.0f, 1.5f);
        } else {
            this.walkAnimationState.applyWalk(((SealRenderState)((Object)entity)).walkAnimationPos, ((SealRenderState)((Object)entity)).walkAnimationSpeed, 1.0f, 4.0f);
        }
    }
}

