/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.VenochemAnimation;
import baguchan.frostrealm.client.render.state.VenochemRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class VenochemModel<T extends VenochemRenderState>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leg;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final KeyframeAnimation attackAnimationState;
    private final KeyframeAnimation shootAnimationState;
    private final KeyframeAnimation walkAnimationState;

    public VenochemModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.leg = this.body.getChild("leg");
        this.leg0 = this.leg.getChild("leg0");
        this.leg1 = this.leg.getChild("leg1");
        this.leg2 = this.leg.getChild("leg2");
        this.leg3 = this.leg.getChild("leg3");
        this.leg4 = this.leg.getChild("leg4");
        this.leg5 = this.leg.getChild("leg5");
        this.head = this.body.getChild("head");
        this.tail = this.body.getChild("tail");
        this.tail2 = this.tail.getChild("tail2");
        this.attackAnimationState = VenochemAnimation.attack.bake(root);
        this.shootAnimationState = VenochemAnimation.spit.bake(root);
        this.walkAnimationState = VenochemAnimation.walk.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(37, 2).addBox(-5.0f, -7.0f, -7.0f, 10.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)2.0f));
        PartDefinition leg = body.addOrReplaceChild("leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leg0 = leg.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(-8.0f, 0.25f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-8.0f, (float)3.5f, (float)4.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition leg1 = leg.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, 0.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition leg2 = leg.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(-9.0f, -0.75f, -2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition leg3 = leg.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.75f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition leg4 = leg.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(-9.0f, -0.75f, -2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.48f));
        PartDefinition leg5 = leg.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, -1.0f, -2.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.75f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -6.0f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(69, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)4.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(83, 0).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(82, 16).addBox(-4.0f, -4.0f, 8.0f, 8.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((VenochemRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((VenochemRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.attackAnimationState.apply(((VenochemRenderState)((Object)entity)).attackAnimationState, ((VenochemRenderState)((Object)entity)).ageInTicks);
        this.shootAnimationState.apply(((VenochemRenderState)((Object)entity)).shootAnimationState, ((VenochemRenderState)((Object)entity)).ageInTicks);
        this.walkAnimationState.applyWalk(((VenochemRenderState)((Object)entity)).walkAnimationPos, ((VenochemRenderState)((Object)entity)).walkAnimationSpeed, 4.0f, 3.0f);
    }
}

