/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.YetiAnimations;
import baguchan.frostrealm.client.render.state.YetiRenderState;
import baguchan.frostrealm.entity.Yeti;
import baguchi.bagus_lib.client.layer.IArmor;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class YetiModel<T extends YetiRenderState>
extends EntityModel<T>
implements HeadedModel,
ArmedModel,
IArmor {
    private final ModelPart realRoot;
    private final ModelPart root;
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    private final KeyframeAnimation sitAnimationState;
    private final KeyframeAnimation sitPoseAnimationState;
    private final KeyframeAnimation sitUpAnimationState;
    private final KeyframeAnimation holdingRightAnimationState;
    private final KeyframeAnimation holdingLeftAnimationState;
    private final KeyframeAnimation noticedStealerAnimationState;
    private final KeyframeAnimation snowChargeAnimationState;
    private final KeyframeAnimation idleAnimationState;
    private final KeyframeAnimation walkAnimationState;

    public YetiModel(ModelPart part) {
        super(part);
        this.realRoot = part;
        this.root = part.getChild("root");
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.rightArm = this.root.getChild("right_arm");
        this.leftArm = this.root.getChild("left_arm");
        this.rightLeg = this.root.getChild("right_leg");
        this.leftLeg = this.root.getChild("left_leg");
        this.sitAnimationState = YetiAnimations.sit_start.bake(part);
        this.sitPoseAnimationState = YetiAnimations.sit.bake(part);
        this.sitUpAnimationState = YetiAnimations.sit_stop.bake(part);
        this.holdingRightAnimationState = YetiAnimations.holding_right.bake(part);
        this.holdingLeftAnimationState = YetiAnimations.holding_left.bake(part);
        this.noticedStealerAnimationState = YetiAnimations.noticed_stealer.bake(part);
        this.snowChargeAnimationState = YetiAnimations.thorw_pre.bake(part);
        this.idleAnimationState = YetiAnimations.idle.bake(part);
        this.walkAnimationState = YetiAnimations.walk.bake(part);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(5, 24).addBox(-14.0f, -2.0f, -8.0f, 28.0f, 20.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-27.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(44, 61).addBox(-2.5f, -3.0f, -3.0f, 8.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(5, 61).addBox(-5.5f, -3.0f, -3.0f, 8.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(44, 90).addBox(0.0f, -0.5f, -4.0f, 8.0f, 26.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.0f, (float)-27.0f, (float)-1.0f));
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(4, 90).addBox(-8.0f, -0.5f, -5.0f, 8.0f, 26.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-14.0f, (float)-27.0f, (float)-1.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -7.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, 2.0f, -9.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 7).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-27.0f, (float)-6.0f));
        PartDefinition horn = head.addOrReplaceChild("horn", CubeListBuilder.create().texOffs(40, 0).addBox(4.0f, -2.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-6.0f, -2.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-6.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = ((YetiRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((YetiRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        float f = 1.0f;
        if (f < 1.0f) {
            f = 1.0f;
        }
        float f1 = ((YetiRenderState)((Object)entity)).attackTime;
        if (((YetiRenderState)((Object)entity)).state == Yeti.State.TRADE) {
            this.head.xRot = 0.5235988f;
            this.head.yRot = 0.0f;
            if (((YetiRenderState)((Object)entity)).mainArm == HumanoidArm.LEFT) {
                this.holdingRightAnimationState.applyStatic();
            } else {
                this.holdingLeftAnimationState.applyStatic();
            }
        }
        if (f1 > 0.0f) {
            if (((YetiRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                this.rightArm.xRot = 0.0f;
                this.rightArm.zRot -= Mth.sin((float)((float)Math.PI * f1)) * 0.75f;
                this.rightArm.xRot -= Mth.sin((float)((float)Math.PI * f1)) * 0.5f;
            } else {
                this.leftArm.xRot = 0.0f;
                this.leftArm.zRot += Mth.sin((float)((float)Math.PI * f1)) * 0.75f;
                this.leftArm.xRot -= Mth.sin((float)((float)Math.PI * f1)) * 0.5f;
            }
        }
        if (((YetiRenderState)((Object)entity)).isPassenger) {
            this.sitPoseAnimationState.applyStatic();
        } else if (((YetiRenderState)((Object)entity)).sitPoseAnimationState.isStarted() || ((YetiRenderState)((Object)entity)).sitAnimationState.isStarted() || ((YetiRenderState)((Object)entity)).sitUpAnimationState.isStarted()) {
            this.sitAnimationState.apply(((YetiRenderState)((Object)entity)).sitAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
            this.sitPoseAnimationState.apply(((YetiRenderState)((Object)entity)).sitPoseAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
            this.sitUpAnimationState.apply(((YetiRenderState)((Object)entity)).sitUpAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
        } else {
            this.walkAnimationState.applyWalk(((YetiRenderState)((Object)entity)).walkAnimationPos, ((YetiRenderState)((Object)entity)).walkAnimationSpeed, 1.0f, 3.0f);
        }
        this.noticedStealerAnimationState.apply(((YetiRenderState)((Object)entity)).noticedStealerAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
        this.snowChargeAnimationState.apply(((YetiRenderState)((Object)entity)).snowChargeAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
        this.idleAnimationState.apply(((YetiRenderState)((Object)entity)).idleAnimationState, ((YetiRenderState)((Object)entity)).ageInTicks);
    }

    public ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(EntityRenderState entityRenderState, HumanoidArm p_102925_, PoseStack p_102926_) {
        this.root.translateAndRotate(p_102926_);
        this.getArm(p_102925_).translateAndRotate(p_102926_);
        p_102926_.translate(0.0, 0.8, 0.0);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.rightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.leftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.rightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.leftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, 0.25f, -0.325f);
        poseStack.scale(1.1f, 1.1f, 1.1f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.1f, -0.1f);
        poseStack.scale(2.825f, 2.0f, 2.825f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        poseStack.scale(2.0f, 1.01f, 2.0f);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        modelPart.translateAndRotate(poseStack);
        if (modelPart == this.rightArm) {
            poseStack.translate(0.195f, 0.0f, 0.0f);
        } else {
            poseStack.translate(-0.195f, 0.0f, 0.0f);
        }
        poseStack.scale(1.85f, 1.65f, 1.85f);
    }
}

