/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class SnowParticle
extends SingleQuadParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private static final float FALL_ACC = 0.25f;
    private static final float WIND_BIG = 2.0f;
    private float rotSpeed;
    private final float particleRandom;
    private final float spinAcceleration;

    public SnowParticle(ClientLevel p_277612_, double p_278010_, double p_277614_, double p_277673_, double xd, double yd, double zd, TextureAtlasSprite sprite) {
        super(p_277612_, p_278010_, p_277614_, p_277673_, sprite);
        float f;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.particleRandom = this.random.nextFloat();
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.lifetime = 200;
        this.gravity = 0.015f;
        this.quadSize = f = 0.15f;
        this.setSize(f, f);
        this.friction = 1.0f;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += xd;
        this.yd += yd;
        this.zd += zd;
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 200 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_105793_) {
            this.sprite = p_105793_;
        }

        public Particle createParticle(SimpleParticleType p_446632_, ClientLevel p_107095_, double x, double y, double z, double motionX, double motionY, double motionZ, RandomSource random) {
            return new SnowParticle(p_107095_, x, y, z, motionX, motionY, motionZ, this.sprite.get(random));
        }
    }
}

