/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.model.CrystalFoxModel;
import baguchan.frostrealm.client.render.layer.CrystalFoxHeldItemLayer;
import baguchan.frostrealm.client.render.state.CrystalFoxRenderState;
import baguchan.frostrealm.entity.animal.CrystalFox;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrystalFoxRenderer
extends MobRenderer<CrystalFox, CrystalFoxRenderState, CrystalFoxModel<CrystalFoxRenderState>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox.png");
    private static final ResourceLocation SHEARED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox_sheared.png");
    private static final ResourceLocation SLEEP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox_sleep.png");
    private static final ResourceLocation SLEEP_SHEARED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox_sleep_sheared.png");
    private static final RenderType FOX_GLOW = RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox_glow.png"));
    private static final RenderType FOX_EYES_GLOW = RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/crystal_fox/crystal_fox_eyes_glow.png"));

    public CrystalFoxRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, new CrystalFoxModel(p_173952_.bakeLayer(FrostModelLayers.CRYSTAL_FOX)), 0.5f);
        this.addLayer((RenderLayer)new EyesLayer<CrystalFoxRenderState, CrystalFoxModel<CrystalFoxRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack p_433452_, SubmitNodeCollector p_433171_, int p_434650_, CrystalFoxRenderState p_435883_, float p_433542_, float p_435619_) {
                if (p_435883_.shearable) {
                    super.submit(p_433452_, p_433171_, p_434650_, (EntityRenderState)p_435883_, p_433542_, p_435619_);
                }
            }

            public RenderType renderType() {
                return FOX_GLOW;
            }
        });
        this.addLayer((RenderLayer)new EyesLayer<CrystalFoxRenderState, CrystalFoxModel<CrystalFoxRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack p_433452_, SubmitNodeCollector p_433171_, int p_434650_, CrystalFoxRenderState p_435883_, float p_433542_, float p_435619_) {
                if (p_435883_.state != CrystalFox.State.SLEEPING) {
                    super.submit(p_433452_, p_433171_, p_434650_, (EntityRenderState)p_435883_, p_433542_, p_435619_);
                }
            }

            public RenderType renderType() {
                return FOX_EYES_GLOW;
            }
        });
        this.addLayer(new CrystalFoxHeldItemLayer((RenderLayerParent<CrystalFoxRenderState, CrystalFoxModel<CrystalFoxRenderState>>)this));
    }

    public void extractRenderState(CrystalFox p_364137_, CrystalFoxRenderState p_365146_, float p_361192_) {
        super.extractRenderState((LivingEntity)p_364137_, (LivingEntityRenderState)p_365146_, p_361192_);
        HoldingEntityRenderState.extractHoldingEntityRenderState((LivingEntity)p_364137_, (HoldingEntityRenderState)p_365146_, (ItemModelResolver)this.itemModelResolver);
        p_365146_.eatAnimationState.copyFrom(p_364137_.eatAnimationState);
        p_365146_.shearable = p_364137_.isShearableWithoutConditions();
        p_365146_.state = CrystalFox.State.get(p_364137_.getState());
    }

    public CrystalFoxRenderState createRenderState() {
        return new CrystalFoxRenderState();
    }

    protected void scale(CrystalFoxRenderState p_115314_, PoseStack p_115315_) {
        p_115315_.scale(p_115314_.ageScale, p_115314_.ageScale, p_115314_.ageScale);
        super.scale((LivingEntityRenderState)p_115314_, p_115315_);
    }

    public ResourceLocation getTextureLocation(CrystalFoxRenderState p_110775_1_) {
        if (p_110775_1_.state == CrystalFox.State.SLEEPING) {
            return p_110775_1_.shearable ? SLEEP_TEXTURE : SLEEP_SHEARED_TEXTURE;
        }
        return p_110775_1_.shearable ? TEXTURE : SHEARED_TEXTURE;
    }
}

