/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.render.state.FlyBlockRenderState;
import baguchan.frostrealm.entity.projectile.FlyingBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class FlyingBlockRenderer
extends EntityRenderer<FlyingBlockEntity, FlyBlockRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public FlyingBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public boolean shouldRender(FlyingBlockEntity p_362415_, Frustum p_364047_, double p_362218_, double p_363427_, double p_361722_) {
        return super.shouldRender((Entity)p_362415_, p_364047_, p_362218_, p_363427_, p_361722_);
    }

    public void submit(FlyBlockRenderState p_450955_, PoseStack poseStack, SubmitNodeCollector p_433266_, CameraRenderState p_451470_) {
        BlockState blockstate = p_450955_.movingBlockRenderState.blockState;
        if (blockstate.getRenderShape() == RenderShape.MODEL) {
            poseStack.pushPose();
            poseStack.translate(0.0, -0.5, 0.0);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-p_450955_.yRot));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(p_450955_.xRot));
            poseStack.translate(-0.5, -0.5, -0.5);
            p_433266_.submitMovingBlock(poseStack, p_450955_.movingBlockRenderState);
            poseStack.popPose();
            super.submit((EntityRenderState)p_450955_, poseStack, p_433266_, p_451470_);
        }
    }

    public FlyBlockRenderState createRenderState() {
        return new FlyBlockRenderState();
    }

    public void extractRenderState(FlyingBlockEntity p_364559_, FlyBlockRenderState p_360509_, float p_361019_) {
        BlockPos blockpos;
        super.extractRenderState((Entity)p_364559_, (EntityRenderState)p_360509_, p_361019_);
        p_360509_.movingBlockRenderState.blockPos = blockpos = BlockPos.containing((double)p_364559_.getX(), (double)p_364559_.getBoundingBox().maxY, (double)p_364559_.getZ());
        p_360509_.movingBlockRenderState.blockState = p_364559_.getBlockState();
        p_360509_.movingBlockRenderState.biome = p_364559_.level().getBiome(blockpos);
        p_360509_.movingBlockRenderState.level = p_364559_.level();
        p_360509_.xRot = p_364559_.getXRot(p_361019_);
        p_360509_.yRot = p_364559_.getYRot(p_361019_);
    }
}

