/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.sounds;

import baguchan.frostrealm.capability.FrostWeatherManager;
import baguchan.frostrealm.weather.FrostWeather;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;

public class FrostAmbientSoundsHandler
implements AmbientSoundHandler {
    private static final int LOOP_SOUND_CROSS_FADE_TIME = 100;
    private static final float SKY_MOOD_RECOVERY_RATE = 0.001f;
    private final SoundManager soundManager;
    private final Object2ObjectArrayMap<FrostWeather, LoopSoundInstance> loopSounds = new Object2ObjectArrayMap();
    @Nullable
    private FrostWeather previousWeather;

    public FrostAmbientSoundsHandler(SoundManager p_1196100_) {
        this.soundManager = p_1196100_;
    }

    public void tick() {
        this.loopSounds.values().removeIf(AbstractTickableSoundInstance::isStopped);
        FrostWeather frostWeather = FrostWeatherManager.getFrostWeather();
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null) {
            BlockPos blockpos = Minecraft.getInstance().player.blockPosition();
            if (frostWeather.getNonAffectableBiome().isPresent() && Minecraft.getInstance().level.getBiome(blockpos).is(frostWeather.getNonAffectableBiome().get())) {
                this.loopSounds.values().forEach(LoopSoundInstance::fadeOut);
            } else if (frostWeather != this.previousWeather) {
                this.loopSounds.values().forEach(LoopSoundInstance::fadeOut);
                if (this.loopSounds.values().isEmpty()) {
                    frostWeather.getSoundEvents().ifPresent(soundEvent -> this.loopSounds.compute((Object)frostWeather, (p_174924_, p_174925_) -> {
                        if (p_174925_ == null) {
                            p_174925_ = new LoopSoundInstance((SoundEvent)soundEvent);
                            this.soundManager.play((SoundInstance)p_174925_);
                        }
                        p_174925_.fadeIn();
                        return p_174925_;
                    }));
                    this.previousWeather = frostWeather;
                }
            } else {
                BlockPos blockpos2 = Minecraft.getInstance().level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos);
                BlockPos blockpos1 = blockpos2.below();
                if (blockpos1.getY() > blockpos.getY() + 1 && Minecraft.getInstance().level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY()) + 10) {
                    this.loopSounds.values().forEach(LoopSoundInstance::fadeOut);
                } else {
                    if (blockpos1.getY() > blockpos.getY() + 1 && Minecraft.getInstance().level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() > Mth.floor((float)blockpos.getY())) {
                        this.loopSounds.values().forEach(LoopSoundInstance::toneDown);
                    } else {
                        this.loopSounds.values().forEach(LoopSoundInstance::toneUp);
                    }
                    this.loopSounds.values().forEach(LoopSoundInstance::fadeIn);
                }
            }
        }
    }

    public static class LoopSoundInstance
    extends AbstractTickableSoundInstance {
        private int fadeDirection;
        private int fade;
        private float tone;
        private int toneDirection;

        public LoopSoundInstance(SoundEvent p_119658_) {
            super(p_119658_, SoundSource.AMBIENT, SoundInstance.createUnseededRandom());
            this.looping = true;
            this.delay = 0;
            this.volume = 1.0f;
            this.relative = true;
        }

        public void tick() {
            if (this.fade < 0) {
                this.stop();
            }
            this.fade += this.fadeDirection;
            this.tone += (float)this.toneDirection * 0.1f;
            this.volume = Mth.clamp((float)((float)this.fade / 200.0f), (float)0.0f, (float)Mth.clamp((float)(0.85f + this.tone), (float)0.0f, (float)3.0f));
        }

        public void fadeOut() {
            this.fade = Math.clamp((long)this.fade, 0, 200);
            this.fadeDirection = -1;
        }

        public void toneDown() {
            this.tone = Math.clamp(this.tone, 0.0f, 3.0f);
            this.toneDirection = -1;
        }

        public void toneUp() {
            this.tone = Math.clamp(this.tone, 0.0f, 3.0f);
            this.toneDirection = 1;
        }

        public void fadeIn() {
            this.fade = Math.clamp((long)this.fade, 0, 200);
            this.fadeDirection = 1;
        }
    }
}

