/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.command;

import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.message.ChangeWeatherMessage;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.weather.FrostWeather;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FrostWeatherCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(p_212392_ -> Component.translatable((String)"commands.frostrealm.frost_weather.set.fail"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder frostWeatherCommand = (LiteralArgumentBuilder)Commands.literal((String)"frost_weather").requires(player -> player.hasPermission(2));
        ((LiteralArgumentBuilder)frostWeatherCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(p_139190_ -> FrostWeatherCommand.setClear((CommandSourceStack)p_139190_.getSource(), 6000))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(p_139188_ -> FrostWeatherCommand.setClear((CommandSourceStack)p_139188_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_139188_, (String)"duration") * 20))))).then(((RequiredArgumentBuilder)Commands.argument((String)"set_weather", (ArgumentType)ResourceKeyArgument.key((ResourceKey)FrostWeathers.FROST_WEATHER.getRegistryKey())).executes(ctx -> FrostWeatherCommand.setRain(FrostWeatherCommand.getFrostWeather((CommandContext<CommandSourceStack>)ctx, "set_weather"), (CommandSourceStack)ctx.getSource(), 6000))).then(Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(ctx -> FrostWeatherCommand.setRain(FrostWeatherCommand.getFrostWeather((CommandContext<CommandSourceStack>)ctx, "set_weather"), (CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration") * 20))));
        dispatcher.register(frostWeatherCommand);
    }

    public static Holder.Reference<FrostWeather> getFrostWeather(CommandContext<CommandSourceStack> p_249310_, String p_250729_) throws CommandSyntaxException {
        return FrostWeatherCommand.resolveKey(p_249310_, p_250729_, FrostWeathers.WEATHER_RESOURCE_KEY, ERROR_INVALID_FEATURE);
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> p_212379_, ResourceKey<? extends Registry<T>> p_212380_) {
        return ((CommandSourceStack)p_212379_.getSource()).getServer().registryAccess().lookupOrThrow(p_212380_);
    }

    private static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandSourceStack> p_212374_, String p_212375_, ResourceKey<Registry<T>> p_212376_, DynamicCommandExceptionType p_212377_) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)p_212374_.getArgument(p_212375_, ResourceKey.class);
        Optional optional = resourcekey.cast(p_212376_);
        return (ResourceKey)optional.orElseThrow(() -> p_212377_.create((Object)resourcekey));
    }

    private static <T> Holder.Reference<T> resolveKey(CommandContext<CommandSourceStack> p_248662_, String p_252172_, ResourceKey<Registry<T>> p_249701_, DynamicCommandExceptionType p_249790_) throws CommandSyntaxException {
        ResourceKey resourcekey = FrostWeatherCommand.getRegistryKey(p_248662_, p_252172_, p_249701_, p_249790_);
        return (Holder.Reference)FrostWeatherCommand.getRegistry(p_248662_, p_249701_).get(resourcekey).orElseThrow(() -> p_249790_.create((Object)resourcekey.location()));
    }

    private static int setClear(CommandSourceStack p_139173_, int p_139174_) {
        if (p_139173_.getLevel().dimension() != FrostDimensions.FROSTREALM_LEVEL) {
            p_139173_.sendFailure((Component)Component.translatable((String)"commands.frostrealm.frost_weather.clear.fail_dimension"));
            return p_139174_;
        }
        FrostWeatherSavedData cap = FrostWeatherSavedData.get((Level)p_139173_.getLevel());
        if (cap != null) {
            cap.setFrostWeather(FrostWeathers.NOPE.get());
            cap.setWetherTime(p_139174_);
            ChangeWeatherMessage message = new ChangeWeatherMessage(FrostWeathers.NOPE.get());
            PacketDistributor.sendToPlayersInDimension((ServerLevel)p_139173_.getLevel(), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            p_139173_.sendSuccess(() -> Component.translatable((String)"commands.frostrealm.frost_weather.clear"), true);
        }
        return p_139174_;
    }

    private static int setRain(Holder.Reference<FrostWeather> holder, CommandSourceStack p_139178_, int p_139179_) {
        FrostWeather frostWeather = (FrostWeather)holder.value();
        if (p_139178_.getLevel().dimension() != FrostDimensions.FROSTREALM_LEVEL) {
            p_139178_.sendFailure((Component)Component.translatable((String)"commands.frostrealm.frost_weather.set.fail_dimension"));
            return p_139179_;
        }
        FrostWeatherSavedData cap = FrostWeatherSavedData.get((Level)p_139178_.getLevel());
        if (cap != null) {
            cap.setFrostWeather(frostWeather);
            cap.setWetherTime(p_139179_);
            ChangeWeatherMessage message = new ChangeWeatherMessage(frostWeather);
            PacketDistributor.sendToPlayersInDimension((ServerLevel)p_139178_.getLevel(), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            p_139178_.sendSuccess(() -> Component.translatable((String)"commands.frostrealm.frost_weather.set"), true);
            return p_139179_;
        }
        return p_139179_;
    }
}

