/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.command;

import baguchan.frostrealm.capability.FrostLivingCapability;
import baguchan.frostrealm.message.ChangedColdMessage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class TemperatureCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder temperatureCommand = (LiteralArgumentBuilder)Commands.literal((String)"temperature").requires(player -> player.hasPermission(2));
        temperatureCommand.then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"temperature", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"saturation", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> TemperatureCommand.setTemperature((CommandSourceStack)ctx.getSource(), EntityArgument.getEntity((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"temperature"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"saturation"))))));
        dispatcher.register(temperatureCommand);
    }

    private static int setTemperature(CommandSourceStack commandStack, Entity entity, int temperature, float saturation) {
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                FrostLivingCapability frostLivingCapability = FrostLivingCapability.get(entity);
                frostLivingCapability.setTemperatureLevel(temperature);
                frostLivingCapability.setSaturation(saturation);
                ChangedColdMessage message = new ChangedColdMessage(entity, temperature, saturation);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                commandStack.sendSuccess(() -> Component.translatable((String)"commands.frostrelam.temperature.set", (Object[])new Object[]{entity.getDisplayName()}), true);
                return 1;
            }
            commandStack.sendFailure((Component)Component.translatable((String)"commands.frostrelam.temperature.set.fail.no_living_entity", (Object[])new Object[]{entity.getDisplayName()}));
            return 0;
        }
        commandStack.sendFailure((Component)Component.translatable((String)"commands.frostrelam.temperature.set.fail.no_entity"));
        return 0;
    }
}

