/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.data;

import baguchan.frostrealm.block.crop.BearBerryBushBlock;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostItems;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BlockLootTables
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new HashSet<Block>();
    private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] RARE_SAPLING_DROP_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private static final Set<Item> EXPLOSION_RESISTANT = Set.of();

    public BlockLootTables(HolderLookup.Provider p_344943_) {
        super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), p_344943_);
    }

    protected void add(Block block, LootTable.Builder builder) {
        super.add(block, builder);
        this.knownBlocks.add(block);
    }

    protected void generate() {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.registerEmpty((Block)FrostBlocks.FROST_PORTAL.get());
        this.dropSelf((Block)FrostBlocks.FROZEN_DIRT.get());
        this.add((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get(), p_124193_ -> this.createSingleItemTableWithSilkTouch((Block)p_124193_, (ItemLike)FrostBlocks.FROZEN_DIRT.get()));
        this.add((Block)FrostBlocks.FRIGID_GRASS_BLOCK.get(), p_124193_ -> this.createSingleItemTableWithSilkTouch((Block)p_124193_, (ItemLike)FrostBlocks.FRIGID_STONE.get()));
        this.dropOther((Block)FrostBlocks.FROZEN_FARMLAND.get(), (ItemLike)FrostBlocks.FROZEN_DIRT.get());
        this.dropSelf((Block)FrostBlocks.POINTED_ICE.get());
        this.dropSelf((Block)FrostBlocks.PERMA_SLATE.get());
        this.dropSelf((Block)FrostBlocks.PERMA_SLATE_BRICK.get());
        this.dropSelf((Block)FrostBlocks.PERMA_SLATE_SMOOTH.get());
        this.add((Block)FrostBlocks.PERMA_SLATE_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.PERMA_SLATE_BRICK_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.PERMA_SLATE_BRICK_WALL.get());
        this.dropSelf((Block)FrostBlocks.PERMA_MAGMA.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE.get());
        this.add((Block)FrostBlocks.FRIGID_STONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_BRICK.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_SMOOTH.get());
        this.dropSelf((Block)FrostBlocks.CHISELED_FRIGID_STONE_BRICK.get());
        this.add((Block)FrostBlocks.FRIGID_STONE_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_BRICK_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_BRICK_WALL.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_MOSSY.get());
        this.add((Block)FrostBlocks.FRIGID_STONE_MOSSY_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_MOSSY_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY.get());
        this.add((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FRIGID_STONE_BRICK_MOSSY_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.SHERBET_SAND.get());
        this.dropSelf((Block)FrostBlocks.SHERBET_SANDSTONE.get());
        this.add((Block)FrostBlocks.SHERBET_SANDSTONE_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.SHERBET_SANDSTONE_STAIRS.get());
        this.add((Block)FrostBlocks.GLACINIUM_ORE.get(), this::createGlaciniumDrops);
        this.dropSelf((Block)FrostBlocks.GLACINIUM_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.RAW_GLACINIUM_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_LOG.get());
        this.dropSelf((Block)FrostBlocks.STRIPPED_FROSTROOT_LOG.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_SAPLING.get());
        this.add((Block)FrostBlocks.FROSTROOT_LEAVES.get(), p_124104_ -> this.silkAndStick((Block)p_124104_, (ItemLike)FrostBlocks.FROSTROOT_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_PLANKS.get());
        this.add((Block)FrostBlocks.FROSTROOT_PLANKS_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_PLANKS_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_FENCE.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_FENCE_GATE.get());
        this.add((Block)FrostBlocks.FROSTROOT_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_TRAPDOOR.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_BUTTON.get());
        this.dropSelf((Block)FrostBlocks.FROSTROOT_PRESSURE_PLATE.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_LOG.get());
        this.dropSelf((Block)FrostBlocks.STRIPPED_FROSTBITE_LOG.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_SAPLING.get());
        this.add((Block)FrostBlocks.FROSTBITE_LEAVES.get(), p_124104_ -> this.createFrostbiteLeavesDrops((Block)p_124104_, (Block)FrostBlocks.FROSTBITE_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)FrostBlocks.FROSTBITE_PLANKS.get());
        this.add((Block)FrostBlocks.FROSTBITE_PLANKS_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTBITE_PLANKS_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_FENCE.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_FENCE_GATE.get());
        this.add((Block)FrostBlocks.FROSTBITE_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_TRAPDOOR.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_BUTTON.get());
        this.dropSelf((Block)FrostBlocks.FROSTBITE_PRESSURE_PLATE.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_PLANKS.get());
        this.add((Block)FrostBlocks.ROCK_WOOD_PLANKS_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_PLANKS_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_FENCE.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_FENCE_GATE.get());
        this.add((Block)FrostBlocks.ROCK_WOOD_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_TRAPDOOR.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_BUTTON.get());
        this.dropSelf((Block)FrostBlocks.ROCK_WOOD_PRESSURE_PLATE.get());
        this.dropSelf((Block)FrostBlocks.DRIP_LOG.get());
        this.dropSelf((Block)FrostBlocks.DRIP_SAPLING.get());
        this.add((Block)FrostBlocks.DRIP_LEAVES.get(), p_124104_ -> this.createFrostbiteLeavesDrops((Block)p_124104_, (Block)FrostBlocks.DRIP_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.dropSelf((Block)FrostBlocks.DRIP_PLANKS.get());
        this.add((Block)FrostBlocks.DRIP_PLANKS_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.DRIP_PLANKS_STAIRS.get());
        this.dropSelf((Block)FrostBlocks.DRIP_FENCE.get());
        this.dropSelf((Block)FrostBlocks.DRIP_FENCE_GATE.get());
        this.add((Block)FrostBlocks.DRIP_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf((Block)FrostBlocks.FROSTROOT_TRAPDOOR.get());
        this.dropSelf((Block)FrostBlocks.DRIP_BUTTON.get());
        this.dropSelf((Block)FrostBlocks.DRIP_PRESSURE_PLATE.get());
        this.dropSelf((Block)FrostBlocks.VIGOROSHROOM.get());
        this.dropSelf((Block)FrostBlocks.ARCTIC_POPPY.get());
        this.dropSelf((Block)FrostBlocks.ARCTIC_WILLOW.get());
        this.add((Block)FrostBlocks.COLD_GRASS.get(), this.createFrostGrassDrops((Block)FrostBlocks.COLD_GRASS.get()));
        this.add((Block)FrostBlocks.COLD_TALL_GRASS.get(), this.createDoublePlantWithFrostSeedDrops((Block)FrostBlocks.COLD_TALL_GRASS.get(), (Block)FrostBlocks.COLD_GRASS.get()));
        this.add((Block)FrostBlocks.BEARBERRY_BUSH.get(), p_124096_ -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)p_124096_, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)FrostBlocks.BEARBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BearBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.BEARBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)FrostBlocks.BEARBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BearBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.BEARBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE))))));
        LootItemBlockStatePropertyCondition.Builder lootitemcondition$builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)FrostBlocks.SUGARBEET.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BeetrootBlock.AGE, 3));
        this.add((Block)FrostBlocks.SUGARBEET.get(), this.createCropDrops((Block)FrostBlocks.SUGARBEET.get(), (Item)FrostItems.SUGARBEET.get(), (Item)FrostItems.SUGARBEET.get(), (LootItemCondition.Builder)lootitemcondition$builder));
        LootItemBlockStatePropertyCondition.Builder lootitemcondition$builder2 = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)FrostBlocks.RYE.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BeetrootBlock.AGE, 7));
        this.add((Block)FrostBlocks.RYE.get(), this.createCropDrops((Block)FrostBlocks.RYE.get(), (Item)FrostItems.RYE_SEEDS.get(), (Item)FrostItems.RYE.get(), (LootItemCondition.Builder)lootitemcondition$builder2));
        this.dropSelf((Block)FrostBlocks.RYE_BLOCK.get());
        this.add((Block)FrostBlocks.FROST_CRYSTAL_ORE.get(), this::createFrostCrystalOreDrops);
        this.add((Block)FrostBlocks.GLIMMERROCK_ORE.get(), this::createGlimmerRockOreDrops);
        this.add((Block)FrostBlocks.ASTRIUM_ORE.get(), this::createAstriumOreDrops);
        this.add((Block)FrostBlocks.FROST_CRYSTAL_SLATE_ORE.get(), this::createFrostCrystalOreDrops);
        this.add((Block)FrostBlocks.GLIMMERROCK_SLATE_ORE.get(), this::createGlimmerRockOreDrops);
        this.add((Block)FrostBlocks.ASTRIUM_SLATE_ORE.get(), this::createAstriumOreDrops);
        this.dropSelf((Block)FrostBlocks.FROST_CRYSTAL_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.ASTRIUM_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.RAW_ASTRIUM_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.GLIMMERROCK_BLOCK.get());
        this.add((Block)FrostBlocks.STARDUST_CRYSTAL_ORE.get(), this::createStardustCrystalOreDrops);
        this.dropSelf((Block)FrostBlocks.STARDUST_CRYSTAL_CLUSTER.get());
        this.dropSelf((Block)FrostBlocks.WARPED_CRYSTAL_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.FROST_TORCH.get());
        this.dropOther((Block)FrostBlocks.WALL_FROST_TORCH.get(), (ItemLike)FrostBlocks.FROST_TORCH.get());
        this.add((Block)FrostBlocks.FROST_CAMPFIRE.get(), p_236259_ -> this.createSilkTouchDispatchTable((Block)p_236259_, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)p_236259_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.FROST_CRYSTAL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))))));
        this.dropSelf((Block)FrostBlocks.AURORA_INFUSER.get());
        this.dropSelf((Block)FrostBlocks.WOLFFLUE_BLOCK.get());
        this.dropSelf((Block)FrostBlocks.SNOWPILE_QUAIL_EGG.get());
        this.dropSelf((Block)FrostBlocks.SILK_MOON_EGG.get());
        this.dropSelf((Block)FrostBlocks.SILK_MOON_COCOON.get());
    }

    protected LootTable.Builder createFrostGrassDrops(Block p_252139_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createShearsDispatchTable(p_252139_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_252139_, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.RYE_SEEDS.get())).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    protected LootTable.Builder createDoublePlantWithFrostSeedDrops(Block p_248590_, Block p_248735_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.BLOCK);
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_248735_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(this.hasShears())).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_248590_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.RYE_SEEDS.get())))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_248590_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter)registrylookup, new Block[]{p_248590_}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_248590_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter)registrylookup, new Block[]{p_248590_}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    private void registerSlab(Block b) {
        this.add(b, this.createSlabItemTable(b));
    }

    private LootTable.Builder silkAndStick(Block block, ItemLike nonSilk, float ... nonSilkFortune) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)nonSilk.asItem()))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])nonSilkFortune))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShears()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    protected LootTable.Builder createFrostbiteLeavesDrops(Block p_124264_, Block p_124265_, float ... p_124266_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(p_124264_, p_124265_, p_124266_).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShears()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_124264_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.FROZEN_FRUIT.get())))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createFrostCrystalOreDrops(Block p_176049_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)p_176049_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.FROST_CRYSTAL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createGlimmerRockOreDrops(Block p_176049_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_176049_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.GLIMMERROCK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createAstriumOreDrops(Block p_176049_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_176049_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.ASTRIUM_RAW.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createStardustCrystalOreDrops(Block p_176049_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_176049_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.STARDUST_CRYSTAL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createGlaciniumDrops(Block p_176049_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_176049_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)p_176049_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)FrostItems.GLACINIUM_CRYSTAL.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    private void registerEmpty(Block b) {
        this.add(b, LootTable.lootTable());
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

